/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceMapIndex;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class InstanceReferenceMapDecoder {
    @NeverInline(value="Non-performance critical version.")
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void walkReferences(Pointer baseAddress, InstanceReferenceMap referenceMap, ObjectReferenceVisitor visitor, Object holderObject) {
        InstanceReferenceMapDecoder.walkReferencesInline(baseAddress, referenceMap, visitor, holderObject);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkReferencesInline(Pointer baseAddress, InstanceReferenceMap referenceMap, ObjectReferenceVisitor visitor, Object holderObject) {
        Pointer position = (Pointer)referenceMap;
        int entryCount = position.readInt(0);
        if (entryCount == 0) {
            return;
        }
        position = position.add(4);
        assert (entryCount >= 0);
        UnsignedWord sizeOfEntries = Word.unsigned((int)8).multiply(entryCount);
        Pointer end = position.add(sizeOfEntries);
        while (position.belowThan((UnsignedWord)end)) {
            int offset = position.readInt(0);
            position = position.add(4);
            int count = position.readInt(0);
            position = position.add(4);
            Pointer objRef = baseAddress.add(offset);
            InstanceReferenceMapDecoder.callVisitor(visitor, holderObject, objRef, count);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static InstanceReferenceMap getReferenceMap(NonmovableArray<Byte> referenceMapEncoding, long referenceMapIndex) {
        assert (ReferenceMapIndex.denotesValidReferenceMap(referenceMapIndex));
        assert (referenceMapEncoding.isNonNull());
        return (InstanceReferenceMap)NonmovableByteArrayReader.pointerTo(referenceMapEncoding, referenceMapIndex);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEmpty(InstanceReferenceMap referenceMap) {
        return ((Pointer)referenceMap).readInt(0) == 0;
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitor(ObjectReferenceVisitor visitor, Object holderObject, Pointer objRef, int count) {
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        visitor.visitObjectReferences(objRef, true, referenceSize, holderObject, count);
    }

    public static interface InstanceReferenceMap
    extends WordBase {
    }
}

