/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.Stubs;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.amd64.AMD64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import com.oracle.svm.core.graal.amd64.AMD64FarReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64InterpreterStubs;
import com.oracle.svm.core.graal.amd64.AMD64LoadMethodPointerConstantOp;
import com.oracle.svm.core.graal.amd64.AMD64ReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64SafepointCheckOp;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64AddressLowering;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.graal.code.SharedCompilationResult;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.BranchTargetOutOfBoundsException;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64LIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64LIRKindTool;
import jdk.graal.compiler.core.amd64.AMD64MoveFactory;
import jdk.graal.compiler.core.amd64.AMD64MoveFactoryBase;
import jdk.graal.compiler.core.amd64.AMD64NodeLIRBuilder;
import jdk.graal.compiler.core.amd64.AMD64NodeMatchRules;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.core.gen.LIRGenerationProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64BreakpointOp;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64ControlFlow;
import jdk.graal.compiler.lir.amd64.AMD64FrameMap;
import jdk.graal.compiler.lir.amd64.AMD64FrameMapBuilder;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.amd64.AMD64PrefetchOp;
import jdk.graal.compiler.lir.amd64.AMD64ReadProcid;
import jdk.graal.compiler.lir.amd64.AMD64ReadTimestampCounterWithProcid;
import jdk.graal.compiler.lir.amd64.AMD64VZeroUpper;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.framemap.FrameMapBuilderTool;
import jdk.graal.compiler.lir.framemap.ReferenceMapBuilder;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.AddressLoweringByNodePhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.amd64.AMD64IntrinsicStubs;
import jdk.graal.compiler.vector.lir.amd64.AMD64SimdLIRKindTool;
import jdk.graal.compiler.vector.lir.amd64.AMD64VectorArithmeticLIRGenerator;
import jdk.graal.compiler.vector.lir.amd64.AMD64VectorMoveFactory;
import jdk.graal.compiler.vector.lir.amd64.AMD64VectorNodeMatchRules;
import jdk.graal.compiler.vector.nodes.simd.SimdConstant;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAMD64Backend
extends SubstrateBackend
implements LIRGenerationProvider {
    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAMD64Backend(Providers providers) {
        super(providers);
    }

    public static boolean runtimeToAOTIsAvxSseTransition(TargetDescription target) {
        if (SubstrateUtil.HOSTED) {
            return false;
        }
        if (!AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
            return false;
        }
        AMD64 arch = (AMD64)target.arch;
        EnumSet<?> hostedCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        EnumSet runtimeCPUFeatures = arch.getFeatures();
        return !hostedCPUFeatures.contains(AMD64.CPUFeature.AVX) && runtimeCPUFeatures.contains(AMD64.CPUFeature.AVX);
    }

    private static AllocatableValue getCFITargetRegister() {
        return SubstrateControlFlowIntegrity.useSoftwareCFI() ? SubstrateControlFlowIntegrity.singleton().getCFITargetRegister().asValue() : Value.ILLEGAL;
    }

    public static Object addressDisplacementAnnotation(JavaConstant constant) {
        if (SubstrateUtil.HOSTED) {
            return constant;
        }
        return null;
    }

    public static int addressDisplacement(JavaConstant constant, ConstantReflectionProvider constantReflection) {
        if (SubstrateUtil.HOSTED) {
            return 0;
        }
        return ((SharedConstantReflectionProvider)constantReflection).getImageHeapOffset(constant);
    }

    static void maybeTransitionToNative(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value javaFrameAnchor, Value temp, LIRFrameState state, int newThreadStatus) {
        if (ValueUtil.isIllegal((Value)javaFrameAnchor)) {
            assert (newThreadStatus == -1);
            return;
        }
        assert (VMThreads.StatusSupport.isValidStatus(newThreadStatus));
        Register anchor = ValueUtil.asRegister((Value)javaFrameAnchor);
        Register lastJavaIP = ValueUtil.asRegister((Value)temp);
        int startPos = masm.position();
        masm.leaq(lastJavaIP, new AMD64Address(AMD64.rip));
        crb.recordIndirectCall(startPos, masm.position(), null, state);
        KnownOffsets knownOffsets = KnownOffsets.singleton();
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastIPOffset()), lastJavaIP);
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastSPOffset()), AMD64.rsp);
        masm.movl(new AMD64Address(ReservedRegisters.singleton().getThreadRegister(), knownOffsets.getVMThreadStatusOffset()), newThreadStatus);
    }

    private void vzeroupperBeforeCall(SubstrateAMD64LIRGenerator gen, Value[] arguments, LIRFrameState callState, SharedMethod targetMethod) {
        if (SubstrateAMD64Backend.runtimeToAOTIsAvxSseTransition(gen.target()) && gen.getDestroysCallerSavedRegisters(targetMethod) && !this.isRuntimeToRuntimeCall(callState)) {
            gen.append((LIRInstruction)new AMD64VZeroUpper(arguments, (RegisterConfig)gen.getRegisterConfig()));
        }
    }

    private static ForeignCallDescriptor chooseCPUFeatureVariant(ForeignCallDescriptor descriptor, TargetDescription target, EnumSet<?> runtimeCheckedCPUFeatures) {
        EnumSet<?> buildtimeCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        EnumSet amd64Features = ((AMD64)target.arch).getFeatures();
        if (buildtimeCPUFeatures.containsAll(runtimeCheckedCPUFeatures) || !amd64Features.containsAll(runtimeCheckedCPUFeatures)) {
            return descriptor;
        }
        GraalError.guarantee((boolean)RuntimeCompilation.isEnabled(), (String)"should be reached in JIT mode only");
        return new ForeignCallDescriptor(descriptor.getName() + "RTC", descriptor.getResultType(), descriptor.getArgumentTypes(), descriptor.getSideEffect(), descriptor.getKilledLocations(), descriptor.canDeoptimize(), descriptor.isGuaranteedSafepoint());
    }

    private FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig, SharedMethod method) {
        SubstrateAMD64FrameMap frameMap = new SubstrateAMD64FrameMap(this.getCodeCache(), (SubstrateAMD64RegisterConfig)registerConfig, new SubstrateReferenceMapBuilderFactory(), method);
        return new AMD64FrameMapBuilder((FrameMap)frameMap, this.getCodeCache(), registerConfig);
    }

    private static boolean isCalleeSaved(Register register, RegisterConfig config, SharedMethod method) {
        RegisterAttributes registerAttributes = (RegisterAttributes)config.getAttributesMap().get(register.number);
        return registerAttributes.isCalleeSave() || registerAttributes.isAllocatable() && method.hasCalleeSavedRegisters();
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        SubstrateCallingConventionKind ccKind = method.getCallingConventionKind();
        SubstrateCallingConventionType ccType = ccKind.isCustom() ? method.getCustomCallingConventionType() : ccKind.toType(false);
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)ccType, (ResolvedJavaMethod)method, (ValueKindFactory)this);
        SubstrateLIRGenerationResult lirGenerationResult = new SubstrateLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig(), method), callingConvention, registerAllocationConfig, method);
        FrameMap frameMap = ((FrameMapBuilderTool)lirGenerationResult.getFrameMapBuilder()).getFrameMap();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        if (stubType == Deoptimizer.StubType.InterpreterEnterStub) {
            assert (InterpreterSupport.isEnabled());
            frameMap.reserveOutgoing(AMD64InterpreterStubs.additionalFrameSizeEnterStub());
        } else if (stubType == Deoptimizer.StubType.InterpreterLeaveStub) {
            assert (InterpreterSupport.isEnabled());
            frameMap.reserveOutgoing(AMD64InterpreterStubs.additionalFrameSizeLeaveStub());
        }
        return lirGenerationResult;
    }

    protected static boolean isVectorizationTarget() {
        return ((AMD64)ConfigurationValues.getTarget().arch).getFeatures().contains(AMD64.CPUFeature.AVX);
    }

    protected AMD64ArithmeticLIRGenerator createArithmeticLIRGen(RegisterValue nullRegisterValue) {
        if (SubstrateAMD64Backend.isVectorizationTarget()) {
            return AMD64VectorArithmeticLIRGenerator.create((AllocatableValue)nullRegisterValue, (Architecture)ConfigurationValues.getTarget().arch);
        }
        return new AMD64ArithmeticLIRGenerator((AllocatableValue)nullRegisterValue);
    }

    protected AMD64MoveFactoryBase createMoveFactory(LIRGenerationResult lirGenRes, MoveFactory.BackupSlotProvider backupSlotProvider) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        SubstrateAMD64MoveFactory factory = new SubstrateAMD64MoveFactory(backupSlotProvider, method, this.createLirKindTool());
        if (SubstrateAMD64Backend.isVectorizationTarget()) {
            factory = new AMD64VectorMoveFactory((AMD64MoveFactoryBase)factory, backupSlotProvider, AMD64Assembler.AMD64SIMDInstructionEncoding.forFeatures((EnumSet)((AMD64)ConfigurationValues.getTarget().arch).getFeatures()));
        }
        return factory;
    }

    protected LIRKindTool createLirKindTool() {
        return new SubstrateAMD64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister().asValue() : null;
        AMD64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen(nullRegisterValue);
        MoveFactory.BackupSlotProvider backupSlotProvider = new MoveFactory.BackupSlotProvider(lirGenRes.getFrameMapBuilder());
        AMD64MoveFactoryBase moveFactory = this.createMoveFactory(lirGenRes, backupSlotProvider);
        if (SubstrateAMD64Backend.isVectorizationTarget()) {
            return new SubstrateAMD64VectorLIRGenerator(this, this.createLirKindTool(), arithmeticLIRGen, (MoveFactory)moveFactory, this.getProviders(), lirGenRes);
        }
        return new SubstrateAMD64LIRGenerator(this.createLirKindTool(), arithmeticLIRGen, (MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AMD64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        if (SubstrateAMD64Backend.isVectorizationTarget()) {
            return new AMD64VectorNodeMatchRules(lirGen);
        }
        return new AMD64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AMD64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAMD64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    protected static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator) {
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        AMD64MacroAssembler masm = this.createAssembler(options);
        PatchConsumerFactory patchConsumerFactory = SubstrateUtil.HOSTED ? PatchConsumerFactory.HostedPatchConsumerFactory.factory() : PatchConsumerFactory.NativePatchConsumerFactory.factory();
        masm.setCodePatchingAnnotationConsumer(patchConsumerFactory.newConsumer(compilationResult));
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        CallingConvention callingConvention = lirGenResult.getCallingConvention();
        FrameContext frameContext = this.createFrameContext(method, stubType, callingConvention);
        DebugContext debug = lir.getDebug();
        Register uncompressedNullRegister = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister() : Register.None;
        CompilationResultBuilder crb = factory.createBuilder((CoreProviders)this.getProviders(), frameMap, (Assembler)masm, (DataBuilder)dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, lir);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        SharedCompilationResult sharedCompilationResult = (SharedCompilationResult)compilationResult;
        SubstrateAMD64FrameMap substrateAMD64FrameMap = (SubstrateAMD64FrameMap)frameMap;
        sharedCompilationResult.setFrameSize(substrateAMD64FrameMap.frameSize());
        if (substrateAMD64FrameMap.needsFramePointer()) {
            sharedCompilationResult.setFramePointerSaveAreaOffset(substrateAMD64FrameMap.getFramePointerSaveAreaOffset());
        }
        return crb;
    }

    protected AMD64MacroAssembler createAssembler(OptionValues options) {
        return new AMD64MacroAssembler(this.getTarget(), options, true);
    }

    protected FrameContext createFrameContext(SharedMethod method, Deoptimizer.StubType stubType, CallingConvention callingConvention) {
        if (stubType == Deoptimizer.StubType.EntryStub) {
            return new DeoptEntryStubContext(method, callingConvention);
        }
        if (stubType == Deoptimizer.StubType.ExitStub) {
            return new DeoptExitStubContext(method, callingConvention);
        }
        if (stubType == Deoptimizer.StubType.InterpreterEnterStub) {
            assert (InterpreterSupport.isEnabled());
            return new AMD64InterpreterStubs.InterpreterEnterStubContext(method, callingConvention);
        }
        if (stubType == Deoptimizer.StubType.InterpreterLeaveStub) {
            assert (InterpreterSupport.isEnabled());
            return new AMD64InterpreterStubs.InterpreterLeaveStubContext(method, callingConvention);
        }
        return new SubstrateAMD64FrameContext(method, callingConvention);
    }

    @Override
    public BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider codeCache) {
        CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
        return new AddressLoweringByNodePhase((AddressLoweringByNodePhase.AddressLowering)new SubstrateAMD64AddressLowering(compressEncoding));
    }

    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        crb.emitLIR();
        if (((Boolean)GraalOptions.OptimizeLongJumps.getValue(crb.getOptions())).booleanValue()) {
            this.optimizeLongJumps(crb);
        }
    }

    public AMD64Assembler createAssemblerNoOptions() {
        OptionValues o = new OptionValues((UnmodifiableEconomicMap)EconomicMap.create());
        return this.createAssembler(o);
    }

    protected void resetForEmittingCode(CompilationResultBuilder crb) {
        crb.resetForEmittingCode();
    }

    @Override
    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        AMD64Assembler asm = this.createAssemblerNoOptions();
        if (SubstrateControlFlowIntegrity.enabled()) {
            asm.endbranch();
        }
        asm.movq(AMD64.rax, new AMD64Address(threadArg.getRegister(), threadIsolateOffset));
        asm.addq(AMD64.rax, methodIdArg.getRegister());
        if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
            Register jumpTargetRegister = SubstrateControlFlowIntegrity.singleton().getCFITargetRegister();
            asm.movq(jumpTargetRegister, new AMD64Address(AMD64.rax, methodObjEntryPointOffset));
            asm.jmp(jumpTargetRegister);
        } else {
            asm.jmp(new AMD64Address(AMD64.rax, methodObjEntryPointOffset));
        }
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        byte[] instructions = asm.close(true);
        result.setTargetCode(instructions, instructions.length);
        result.setTotalFrameSize(FrameAccess.returnAddressSize());
        return result;
    }

    private void optimizeLongJumps(CompilationResultBuilder crb) {
        this.resetForEmittingCode(crb);
        try {
            crb.emitLIR();
        }
        catch (BranchTargetOutOfBoundsException e) {
            AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
            masm.disableOptimizeLongJumpsAfterException();
            crb.resetForEmittingCode();
            crb.emitLIR();
        }
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo, Object stub) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new SubstrateAMD64RegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    protected class SubstrateAMD64LIRGenerator
    extends AMD64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, null, moveFactory, providers, lirGenRes);
        }

        public void emitReturn(JavaKind kind, Value input) {
            AllocatableValue operand = Value.ILLEGAL;
            if (input != null) {
                operand = this.resultOperandFor(kind, input.getValueKind());
                this.emitMove(operand, input);
            }
            this.append((LIRInstruction)this.emitReturnOp(operand));
        }

        protected AMD64ReturnOp emitReturnOp(AllocatableValue operand) {
            return new AMD64ReturnOp((Value)operand);
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        protected boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            if (this.getResult().getMethod().isDeoptTarget()) {
                return true;
            }
            return targetMethod == null || !((SharedMethod)targetMethod).hasCalleeSavedRegisters();
        }

        protected Value emitIndirectForeignCallAddress(ForeignCallLinkage linkage) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            if (SubstrateUtil.HOSTED && targetMethod.forceIndirectCall()) {
                DynamicImageLayerInfo.PriorLayerMethodLocation methodLocation = DynamicImageLayerInfo.singleton().getPriorLayerMethodLocation(targetMethod);
                Variable basePointerAddress = this.newVariable((ValueKind)this.getLIRKindTool().getWordKind());
                this.append((LIRInstruction)new AMD64CGlobalDataLoadAddressOp(methodLocation.base(), (AllocatableValue)basePointerAddress));
                Value codeOffsetInSection = this.emitConstant(this.getLIRKindTool().getWordKind(), (Constant)JavaConstant.forLong((long)methodLocation.offset()));
                return this.getArithmetic().emitAdd((Value)basePointerAddress, codeOffsetInSection, false);
            }
            if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                return null;
            }
            Value codeOffsetInImage = this.emitConstant(this.getLIRKindTool().getWordKind(), (Constant)JavaConstant.forLong((long)targetMethod.getImageCodeOffset()));
            Value codeInfo = this.emitJavaConstant(SubstrateObjectConstant.forObject(targetMethod.getImageCodeInfo()));
            AMD64AddressValue codeStartField = new AMD64AddressValue((ValueKind)this.getLIRKindTool().getWordKind(), this.asAllocatable(codeInfo), KnownOffsets.singleton().getImageCodeInfoCodeStartOffset());
            Variable codeStart = this.getArithmetic().emitLoad(this.getLIRKindTool().getWordKind(), (Value)codeStartField, null, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
            return this.getArithmetic().emitAdd((Value)codeStart, codeOffsetInImage, false);
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            Value exceptionTemp = this.getExceptionTemp(info != null && info.exceptionEdge != null);
            SubstrateAMD64Backend.this.vzeroupperBeforeCall(this, arguments, info, targetMethod);
            if (SubstrateBackend.shouldEmitOnlyIndirectCalls() || targetMethod.forceIndirectCall()) {
                RegisterValue targetRegister = AMD64.rax.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool()));
                this.emitMove((AllocatableValue)targetRegister, targetAddress);
                this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, arguments, temps, (Value)targetRegister, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp, null));
            } else {
                assert (targetAddress == null);
                this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, arguments, temps, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp));
            }
        }

        private Value getExceptionTemp(boolean hasExceptionEdge) {
            if (hasExceptionEdge) {
                return this.getRegisterConfig().getReturnRegister(JavaKind.Object).asValue();
            }
            return Value.ILLEGAL;
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        @Override
        public void emitVerificationMarker(Object marker) {
            this.append(new VerificationMarkerOp(marker));
        }

        @Override
        public void emitInstructionSynchronizationBarrier() {
            throw VMError.shouldNotReachHere("AMD64 does not need instruction synchronization");
        }

        @Override
        public void emitExitMethodAddressResolution(Value ip) {
            PLTGOTConfiguration configuration = PLTGOTConfiguration.singleton();
            RegisterValue exitThroughRegisterValue = configuration.getExitMethodAddressResolutionRegister(this.getRegisterConfig()).asValue(ip.getValueKind());
            this.emitMove((AllocatableValue)exitThroughRegisterValue, ip);
            this.append(configuration.createExitMethodAddressResolutionOp(exitThroughRegisterValue));
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value sp, Value ip, boolean fromMethodWithCalleeSavedRegisters) {
            this.append((LIRInstruction)new AMD64FarReturnOp(result, this.asAllocatable(sp), this.asAllocatable(ip), fromMethodWithCalleeSavedRegisters));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AMD64PrefetchOp(this.asAddressValue(address), SubstrateOptions.AllocatePrefetchInstr.getValue().intValue()));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitConvertNullToZero(AllocatableValue result, AllocatableValue value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertNullToZeroOp(result, value));
            } else {
                this.emitMove(result, (Value)value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitProcid(AllocatableValue dst) {
            if (this.supportsCPUFeature(AMD64.CPUFeature.RDPID)) {
                this.append((LIRInstruction)new AMD64ReadProcid(dst));
            } else {
                AMD64ReadTimestampCounterWithProcid procid = new AMD64ReadTimestampCounterWithProcid();
                this.append((LIRInstruction)procid);
                this.emitMove(dst, (Value)procid.getProcidResult());
            }
            this.getArithmetic().emitAnd((Value)dst, this.emitConstant(LIRKind.value((PlatformKind)AMD64Kind.DWORD), (Constant)JavaConstant.forInt((int)4095)));
        }

        public int getArrayLengthOffset() {
            return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
        }

        public boolean isReservedRegister(Register r) {
            return ReservedRegisters.singleton().isReservedRegister(r);
        }

        protected void emitRangeTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, SwitchStrategy remainingStrategy, LabelRef[] remainingTargets, AllocatableValue key) {
            super.emitRangeTableSwitch(lowKey, defaultTarget, targets, remainingStrategy, remainingTargets, key);
            this.markIndirectBranchTargets(targets);
        }

        protected void emitHashTableSwitch(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value, Value hash) {
            super.emitHashTableSwitch(keys, defaultTarget, targets, value, hash);
            this.markIndirectBranchTargets(targets);
        }

        private void markIndirectBranchTargets(LabelRef[] labels) {
            for (LabelRef label : labels) {
                label.getTargetBlock().setIndirectBranchTarget();
            }
        }
    }

    static class SubstrateAMD64FrameMap
    extends AMD64FrameMap {
        private boolean needsFramePointer;
        private int framePointerSaveAreaOffset = -1;
        private boolean finalized;

        SubstrateAMD64FrameMap(CodeCacheProvider codeCache, SubstrateAMD64RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory, SharedMethod method) {
            super(codeCache, (RegisterConfig)registerConfig, referenceMapFactory, registerConfig.shouldUseBasePointer());
            if (!this.preserveFramePointer() && SubstrateAMD64Backend.isCalleeSaved(AMD64.rbp, registerConfig, method)) {
                assert (this.initialSpillSize == this.returnAddressSize() && this.spillSize == this.initialSpillSize) : "rbp must be right after the return address";
                this.initialSpillSize += this.getTarget().wordSize;
                this.spillSize += this.getTarget().wordSize;
            }
        }

        public void finish() {
            this.finalized = true;
            if (this.needsFramePointer) {
                this.allocateFramePointerSaveArea();
            }
            super.finish();
        }

        private void allocateFramePointerSaveArea() {
            assert (this.framePointerSaveAreaOffset == -1);
            int framePointerSaveAreaSize = this.getTarget().wordSize;
            if (this.preserveFramePointer()) {
                framePointerSaveAreaSize += this.returnAddressSize();
            }
            this.framePointerSaveAreaOffset = NumUtil.roundUp((int)this.outgoingSize, (int)framePointerSaveAreaSize);
            this.reserveOutgoing(this.framePointerSaveAreaOffset + framePointerSaveAreaSize);
        }

        void setNeedsFramePointer() {
            assert (!this.finalized);
            this.needsFramePointer = true;
        }

        boolean needsFramePointer() {
            assert (this.finalized);
            return this.needsFramePointer;
        }

        int getFramePointerSaveAreaOffset() {
            assert (this.needsFramePointer()) : "no frame pointer save area";
            assert (this.framePointerSaveAreaOffset != -1);
            return this.framePointerSaveAreaOffset;
        }
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, CallingConvention callingConvention, RegisterAllocationConfig registerAllocationConfig, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
            this.method = method;
            if (method.hasCalleeSavedRegisters()) {
                AMD64CalleeSavedRegisters calleeSavedRegisters = AMD64CalleeSavedRegisters.singleton();
                FrameMap frameMap = ((FrameMapBuilderTool)frameMapBuilder).getFrameMap();
                int registerSaveAreaSizeInBytes = calleeSavedRegisters.getSaveAreaSize();
                StackSlot calleeSaveArea = frameMap.allocateStackMemory(registerSaveAreaSizeInBytes, frameMap.getTarget().wordSize);
                calleeSavedRegisters.verifySaveAreaOffsetInFrame(calleeSaveArea.getRawOffset());
            }
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }

        public boolean emitIndirectTargetBranchMarkers() {
            return SubstrateControlFlowIntegrity.useSoftwareCFI();
        }
    }

    protected static class SubstrateAMD64MoveFactory
    extends AMD64MoveFactory {
        private final SharedMethod method;
        protected final LIRKindTool lirKindTool;

        protected SubstrateAMD64MoveFactory(MoveFactory.BackupSlotProvider backupSlotProvider, SharedMethod method, LIRKindTool lirKindTool) {
            super(backupSlotProvider);
            this.method = method;
            this.lirKindTool = lirKindTool;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        private static JavaConstant getZeroConstant(AllocatableValue dst) {
            int size = dst.getPlatformKind().getSizeInBytes() * 8;
            switch (size) {
                case 32: {
                    return JavaConstant.INT_0;
                }
                case 64: {
                    return JavaConstant.LONG_0;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(size);
        }

        public AMD64LIRInstruction createLoadMethodPointerConstant(AllocatableValue dst, SubstrateMethodPointerConstant constant) {
            SharedMethod sharedMethod;
            ResolvedJavaMethod resolvedJavaMethod;
            if (ImageLayerBuildingSupport.buildingExtensionLayer() && (resolvedJavaMethod = constant.pointer().getMethod()) instanceof SharedMethod && (sharedMethod = (SharedMethod)resolvedJavaMethod).forceIndirectCall()) {
                DynamicImageLayerInfo.PriorLayerMethodLocation methodLocation = DynamicImageLayerInfo.singleton().getPriorLayerMethodLocation(sharedMethod);
                return new AMD64CGlobalDataLoadAddressOp(methodLocation.base(), dst, methodLocation.offset());
            }
            return new AMD64LoadMethodPointerConstantOp(dst, constant);
        }

        public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals((Object)src)) {
                return super.createLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                CompressibleConstant constant = (CompressibleConstant)src;
                return this.loadObjectConstant(dst, constant);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant constant = (SubstrateMethodPointerConstant)src;
                return this.createLoadMethodPointerConstant(dst, constant);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals((Object)src)) {
                return super.createStackLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                CompressibleConstant constant = (CompressibleConstant)src;
                return this.loadObjectConstant(dst, constant);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant constant = (SubstrateMethodPointerConstant)src;
                return this.createLoadMethodPointerConstant(dst, constant);
            }
            return super.createStackLoad(dst, src);
        }

        protected AMD64LIRInstruction loadObjectConstant(AllocatableValue dst, CompressibleConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = ReservedRegisters.singleton().getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAMD64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AMD64Move.MoveFromConstOp(dst, (JavaConstant)constant);
        }

        public static final class LoadCompressedObjectConstantOp
        extends AMD64Move.PointerCompressionOp
        implements StandardOp.LoadConstantOp {
            public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
            private final CompressibleConstant constant;

            static Constant asCompressed(CompressibleConstant constant) {
                return constant.isCompressed() ? constant : constant.compress();
            }

            LoadCompressedObjectConstantOp(AllocatableValue result, CompressibleConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
                super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
                this.constant = constant;
            }

            public Constant getConstant() {
                return this.constant;
            }

            public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                Register resultReg = this.getResultRegister();
                int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
                if (masm.inlineObjects()) {
                    crb.recordInlineDataInCode(inputConstant);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, -559030611, true);
                    } else {
                        masm.movq(resultReg, -2401018187971961171L, true);
                    }
                } else {
                    AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(inputConstant, referenceSize);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, address);
                    } else {
                        masm.movq(resultReg, address);
                    }
                }
                if (!this.constant.isCompressed()) {
                    Register baseReg = this.getBaseRegister();
                    boolean preserveFlagsRegister = true;
                    LoadCompressedObjectConstantOp.emitUncompressWithBaseRegister((AMD64MacroAssembler)masm, (Register)resultReg, (Register)baseReg, (int)this.getShift(), (boolean)preserveFlagsRegister);
                }
            }

            public boolean canRematerializeToStack() {
                return false;
            }
        }
    }

    protected static class SubstrateAMD64LIRKindTool
    extends AMD64LIRKindTool
    implements AMD64SimdLIRKindTool {
        protected SubstrateAMD64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AMD64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }

    protected class SubstrateAMD64VectorLIRGenerator
    extends SubstrateAMD64LIRGenerator {
        public SubstrateAMD64VectorLIRGenerator(SubstrateAMD64Backend this$0, LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        }

        public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
            AMD64VectorArithmeticLIRGenerator vectorGen;
            Variable vectorResult;
            ArithmeticLIRGenerator arithmeticLIRGenerator = this.arithmeticLIRGen;
            if (arithmeticLIRGenerator instanceof AMD64VectorArithmeticLIRGenerator && (vectorResult = (vectorGen = (AMD64VectorArithmeticLIRGenerator)arithmeticLIRGenerator).emitVectorIntegerTestMove(left, right, trueValue, falseValue)) != null) {
                return vectorResult;
            }
            return super.emitIntegerTestMove(left, right, trueValue, falseValue);
        }

        public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
            AMD64VectorArithmeticLIRGenerator vectorGen;
            Variable vectorResult;
            ArithmeticLIRGenerator arithmeticLIRGenerator = this.arithmeticLIRGen;
            if (arithmeticLIRGenerator instanceof AMD64VectorArithmeticLIRGenerator && (vectorResult = (vectorGen = (AMD64VectorArithmeticLIRGenerator)arithmeticLIRGenerator).emitVectorConditionalMove(cmpKind, left, right, cond, unorderedIsTrue, trueValue, falseValue)) != null) {
                return vectorResult;
            }
            return super.emitConditionalMove(cmpKind, left, right, cond, unorderedIsTrue, trueValue, falseValue);
        }

        public Value emitConstant(LIRKind kind, Constant constant) {
            int length = kind.getPlatformKind().getVectorLength();
            if (length == 1) {
                return super.emitConstant(kind, constant);
            }
            if (constant instanceof SimdConstant) {
                assert (((SimdConstant)constant).getVectorLength() == length);
                return super.emitConstant(kind, constant);
            }
            return super.emitConstant(kind, (Constant)SimdConstant.broadcast((Constant)constant, (int)length));
        }

        public Variable emitReverseBytes(Value input) {
            AMD64Kind kind = (AMD64Kind)input.getPlatformKind();
            if (kind.getVectorLength() == 1) {
                return super.emitReverseBytes(input);
            }
            return ((AMD64VectorArithmeticLIRGenerator)this.getArithmetic()).emitReverseBytes(input);
        }
    }

    public class SubstrateAMD64NodeLIRBuilder
    extends AMD64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AMD64BreakpointOp(this.visitInvokeArguments(convention, (Collection<ValueNode>)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(graph, this.gen.getProviders().getMetaAccessExtensionProvider(), nodeValueMap);
        }

        protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
            SubstrateCallingConvention convention = (SubstrateCallingConvention)this.gen.getResult().getCallingConvention();
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                Value inputValue = params[param.index()];
                Variable paramValue = this.gen.emitMove(inputValue);
                if (inputValue.getPlatformKind().getSizeInBytes() < 4) {
                    SubstrateCallingConventionType type = (SubstrateCallingConventionType)convention.getType();
                    assert (!type.outgoing && type.nativeABI());
                    JavaKind kind = convention.getArgumentStorageKinds()[param.index()];
                    JavaKind stackKind = kind.getStackKind();
                    paramValue = kind.isUnsigned() ? this.gen.getArithmetic().emitZeroExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount()) : this.gen.getArithmetic().emitSignExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount());
                }
                assert (paramValue.getValueKind().equals(this.gen.getLIRKind(param.stamp(NodeView.DEFAULT))));
                this.setResult((ValueNode)param, (Value)paramValue);
            }
        }

        public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
            Value[] values = super.visitInvokeArguments(invokeCc, arguments);
            SubstrateCallingConventionType type = (SubstrateCallingConventionType)((SubstrateCallingConvention)invokeCc).getType();
            if (type.usesReturnBuffer()) {
                assert (values.length > 0);
                Value returnBuffer = values[0];
                Variable saved = this.gen.newVariable(returnBuffer.getValueKind());
                this.gen.append(this.gen.getSpillMoveFactory().createMove((AllocatableValue)saved, returnBuffer));
                values[0] = saved;
            }
            if (type.nativeABI()) {
                VMError.guarantee(values.length == invokeCc.getArgumentCount() - 1, "The last argument should be missing.");
                AllocatableValue raxValue = invokeCc.getArgument(values.length);
                VMError.guarantee(raxValue instanceof RegisterValue && ((RegisterValue)raxValue).getRegister().equals((Object)AMD64.rax));
                values = Arrays.copyOf(values, values.length + 1);
                int xmmCount = 0;
                for (int i = 0; i < values.length - 1; ++i) {
                    Value v = values[i];
                    if (!ValueUtil.isRegister((Value)v) || !ValueUtil.asRegister((Value)v).getRegisterCategory().equals((Object)AMD64.XMM)) continue;
                    ++xmmCount;
                }
                assert (xmmCount <= 8);
                this.gen.emitMoveConstant(raxValue, (Constant)JavaConstant.forInt((int)xmmCount));
                values[values.length - 1] = raxValue;
            }
            return values;
        }

        private boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            return ((SubstrateAMD64LIRGenerator)this.gen).getDestroysCallerSavedRegisters(targetMethod);
        }

        private Value getExceptionTemp(CallTargetNode callTarget) {
            return ((SubstrateAMD64LIRGenerator)this.gen).getExceptionTemp(callTarget.invoke() instanceof InvokeWithExceptionNode);
        }

        public BiConsumer<CompilationResultBuilder, Integer> getOffsetRecorder(IndirectCallTargetNode callTargetNode) {
            return null;
        }

        private static AllocatableValue asReturnedValue(AssignedLocation assignedLocation) {
            LIRKind kind;
            assert (assignedLocation.assignsToRegister());
            Register.RegisterCategory category = assignedLocation.register().getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                kind = LIRKind.value((PlatformKind)AMD64Kind.QWORD);
            } else if (category.equals((Object)AMD64.XMM)) {
                kind = LIRKind.value((PlatformKind)AMD64Kind.V128_DOUBLE);
            } else {
                throw VMError.unsupportedFeature("Register category " + String.valueOf(category) + " should not be used for returns spanning multiple registers.");
            }
            return assignedLocation.register().asValue((ValueKind)kind);
        }

        protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
            SubstrateCallingConventionType cc = (SubstrateCallingConventionType)callTarget.callType();
            SubstrateAMD64Backend.verifyCallTarget(callTarget);
            if (callTarget instanceof ComputedIndirectCallTargetNode) {
                assert (!cc.customABI());
                this.emitComputedIndirectCall((ComputedIndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
            } else {
                super.emitInvoke(callTarget, parameters, callState, result);
            }
            if (cc.usesReturnBuffer()) {
                Value returnBuffer = parameters[0];
                long offset = 0L;
                for (AssignedLocation ret : cc.returnSaving) {
                    Value saveLocation = this.gen.getArithmetic().emitAdd(returnBuffer, this.gen.emitJavaConstant((JavaConstant)JavaConstant.forLong((long)offset)), false);
                    AllocatableValue returnedValue = SubstrateAMD64NodeLIRBuilder.asReturnedValue(ret);
                    this.gen.getArithmetic().emitStore(returnedValue.getValueKind(), saveLocation, (Value)returnedValue, callState, MemoryOrderMode.PLAIN);
                    offset += (long)returnedValue.getPlatformKind().getSizeInBytes();
                }
            }
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, parameters, temps, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget)));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AMD64.rax;
            if (((SubstrateCallingConventionType)callTarget.callType()).nativeABI()) {
                targetRegister = AMD64.r10;
            }
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            Value[] multipleResults = new Value[]{};
            SubstrateCallingConventionType callingConventionType = (SubstrateCallingConventionType)callTarget.callType();
            if (callingConventionType.customABI() && callingConventionType.usesReturnBuffer()) {
                multipleResults = Arrays.stream(callingConventionType.returnSaving).map(SubstrateAMD64NodeLIRBuilder::asReturnedValue).toList().toArray(new Value[0]);
            }
            this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, parameters, temps, (Value)targetAddress, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget), this.getOffsetRecorder(callTarget), multipleResults, callingConventionType));
        }

        protected void emitComputedIndirectCall(ComputedIndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            assert (!((SubstrateCallingConventionType)callTarget.callType()).nativeABI());
            RegisterValue addressBase = AMD64.rax.asValue((ValueKind)callTarget.getAddressBase().stamp(NodeView.DEFAULT).getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)addressBase, this.operand((Node)callTarget.getAddressBase()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64ComputedIndirectCallOp(targetMethod, result, parameters, temps, (Value)addressBase, callTarget.getAddressComputation(), callState, this.getExceptionTemp((CallTargetNode)callTarget), this.gen.getLIRKindTool(), SubstrateAMD64Backend.this.getConstantReflection()));
        }

        private AllocatableValue setupJavaFrameAnchor(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            Register frameAnchorRegister = AMD64.rbx;
            RegisterValue frameAnchor = frameAnchorRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)frameAnchor, this.operand((Node)SubstrateBackend.getJavaFrameAnchor(callTarget)));
            return frameAnchor;
        }

        private AllocatableValue setupJavaFrameAnchorTemp(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            return AMD64.r12.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                AMD64SafepointCheckOp op = new AMD64SafepointCheckOp();
                this.append((LIRInstruction)op);
                this.append((LIRInstruction)new AMD64ControlFlow.BranchOp(op.getConditionFlag(), trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AMD64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }

        @Override
        public Variable emitReadReturnAddress() {
            assert (FrameAccess.returnAddressSize() > 0);
            return this.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)this.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize()), (boolean)true));
        }

        public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
            SharedMethod method = (SharedMethod)valueNode.graph().method();
            if (method != null && method.isForeignCallTarget()) {
                return null;
            }
            if (AMD64IntrinsicStubs.shouldInlineIntrinsic((ValueNode)valueNode, (LIRGenerator)this.gen)) {
                return null;
            }
            return this.gen.getForeignCalls().lookupForeignCall(SubstrateAMD64Backend.chooseCPUFeatureVariant(foreignCallDescriptor, this.gen.target(), Stubs.getRequiredCPUFeatures(valueNode.getClass())));
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptEntryStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register frameRegister = registerConfig.getFrameRegister();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            Register firstArgument = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            assert (!firstArgument.equals((Object)gpReturnReg)) : "overwriting return register";
            asm.maybeEmitIndirectTargetMarker();
            asm.subq(registerConfig.getFrameRegister(), FrameAccess.returnAddressSize());
            super.enter(tasm);
            asm.leaq(firstArgument, new AMD64Address(frameRegister, tasm.frameMap.totalFrameSize()));
            asm.movq(ValueUtil.asRegister((Value)this.callingConvention.getArgument(1)), gpReturnReg);
            asm.movdq(ValueUtil.asRegister((Value)this.callingConvention.getArgument(2)), fpReturnReg);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptExitStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            Register firstParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            asm.movq(AMD64.rsp, firstParameter);
            asm.subq(AMD64.rsp, 2 * FrameAccess.returnAddressSize());
            asm.push(ValueUtil.asRegister((Value)this.callingConvention.getArgument(1)));
            asm.push(ValueUtil.asRegister((Value)this.callingConvention.getArgument(2)));
            super.enter(tasm);
        }

        @Override
        public void leave(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            super.leave(tasm);
            asm.movq(fpReturnReg, new AMD64Address(AMD64.rsp, 0));
            asm.addq(AMD64.rsp, 8);
            asm.pop(gpReturnReg);
            if (((SubstrateAMD64RegisterConfig)tasm.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.pop(AMD64.rbp);
            } else {
                asm.addq(AMD64.rsp, 8);
            }
        }
    }

    public static class SubstrateAMD64FrameContext
    implements FrameContext {
        protected final SharedMethod method;
        protected final CallingConvention callingConvention;

        protected SubstrateAMD64FrameContext(SharedMethod method, CallingConvention callingConvention) {
            this.method = method;
            this.callingConvention = callingConvention;
        }

        public void enter(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            this.makeFrame(crb, asm);
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
            SubstrateAMD64FrameContext.maybeSetFramePointer(crb, asm);
            if (this.method.hasCalleeSavedRegisters()) {
                VMError.guarantee(!this.method.isDeoptTarget(), "Deoptimization runtime cannot fill the callee saved registers");
                AMD64CalleeSavedRegisters.singleton().emitSave((AMD64MacroAssembler)crb.asm, crb.frameMap.totalFrameSize(), crb);
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        }

        protected void makeFrame(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            asm.maybeEmitIndirectTargetMarker();
            this.reserveStackFrame(crb, asm);
        }

        protected final void reserveStackFrame(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            this.maybePushBasePointer(crb, asm);
            asm.decrementq(AMD64.rsp, crb.frameMap.frameSize());
        }

        protected void maybePushBasePointer(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            SubstrateAMD64FrameMap frameMap = (SubstrateAMD64FrameMap)crb.frameMap;
            if (frameMap.preserveFramePointer() || SubstrateAMD64Backend.isCalleeSaved(AMD64.rbp, frameMap.getRegisterConfig(), this.method)) {
                asm.push(AMD64.rbp);
                crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_PUSH_RBP);
            }
            if (frameMap.preserveFramePointer() && !frameMap.needsFramePointer()) {
                asm.movq(AMD64.rbp, AMD64.rsp);
            }
        }

        private static void maybeSetFramePointer(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            SubstrateAMD64FrameMap frameMap = (SubstrateAMD64FrameMap)crb.frameMap;
            if (frameMap.needsFramePointer()) {
                if (frameMap.preserveFramePointer()) {
                    int framePointerSaveAreaOffset = frameMap.getFramePointerSaveAreaOffset();
                    asm.movq(asm.makeAddress(AMD64.rsp, framePointerSaveAreaOffset), AMD64.rbp);
                    asm.movq(AMD64.rbp, asm.makeAddress(AMD64.rsp, frameMap.frameSize() + frameMap.getTarget().wordSize));
                    asm.movq(asm.makeAddress(AMD64.rsp, framePointerSaveAreaOffset + frameMap.getTarget().wordSize), AMD64.rbp);
                    asm.leaq(AMD64.rbp, asm.makeAddress(AMD64.rsp, framePointerSaveAreaOffset));
                } else {
                    asm.movq(AMD64.rbp, AMD64.rsp);
                }
                crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_SET_FRAME_POINTER);
            }
        }

        public void leave(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            SubstrateAMD64FrameMap frameMap = (SubstrateAMD64FrameMap)crb.frameMap;
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_START);
            if (this.method.hasCalleeSavedRegisters()) {
                JavaKind returnKind = this.method.getSignature().getReturnKind();
                Register returnRegister = null;
                if (returnKind != JavaKind.Void) {
                    returnRegister = frameMap.getRegisterConfig().getReturnRegister(returnKind);
                }
                AMD64CalleeSavedRegisters.singleton().emitRestore(asm, frameMap.totalFrameSize(), returnRegister, crb);
            }
            if (frameMap.needsFramePointer()) {
                int framePointerOffset = frameMap.preserveFramePointer() ? frameMap.getFramePointerSaveAreaOffset() : 0;
                asm.leaq(AMD64.rsp, asm.makeAddress(AMD64.rbp, frameMap.frameSize() - framePointerOffset));
            } else {
                asm.incrementq(AMD64.rsp, frameMap.frameSize());
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP);
            if (frameMap.preserveFramePointer() || SubstrateAMD64Backend.isCalleeSaved(AMD64.rbp, frameMap.getRegisterConfig(), this.method)) {
                asm.pop(AMD64.rbp);
                crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_POP_RBP);
            }
        }

        public void returned(CompilationResultBuilder crb) {
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_END);
        }
    }

    static class SubstrateAMD64RegisterAllocationConfig
    extends RegisterAllocationConfig {
        private boolean preserveFramePointer;
        private boolean initialized;

        SubstrateAMD64RegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
            super(registerConfig, allocationRestrictedTo);
        }

        protected List<Register> initAllocatable(List<Register> registers) {
            this.initialized = true;
            if (this.preserveFramePointer) {
                ArrayList<Register> allocatableRegisters = new ArrayList<Register>(registers);
                allocatableRegisters.remove(AMD64.rbp);
                return super.initAllocatable(List.copyOf(allocatableRegisters));
            }
            return super.initAllocatable(registers);
        }

        void setPreserveFramePointer() {
            assert (!this.initialized);
            this.preserveFramePointer = true;
        }

        boolean preserveFramePointer() {
            assert (this.initialized);
            return this.preserveFramePointer;
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
            if (SubstrateUtil.assertionsEnabled()) {
                ((AMD64Assembler)crb.asm).int3();
            }
        }
    }

    @Opcode(value="CALL_COMPUTED_INDIRECT")
    public static class SubstrateAMD64ComputedIndirectCallOp
    extends AMD64Call.MethodCallOp {
        public static final LIRInstructionClass<SubstrateAMD64ComputedIndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64ComputedIndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private Value addressBase;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value addressBaseTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private AllocatableValue cfiTargetRegister;
        private final ComputedIndirectCallTargetNode.Computation[] addressComputation;
        private final LIRKindTool lirKindTool;
        private final ConstantReflectionProvider constantReflection;

        public SubstrateAMD64ComputedIndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value addressBase, ComputedIndirectCallTargetNode.Computation[] addressComputation, LIRFrameState state, Value exceptionTemp, LIRKindTool lirKindTool, ConstantReflectionProvider constantReflection) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.addressBase = this.addressBaseTemp = addressBase;
            this.exceptionTemp = exceptionTemp;
            this.addressComputation = addressComputation;
            this.cfiTargetRegister = SubstrateAMD64Backend.getCFITargetRegister();
            this.lirKindTool = lirKindTool;
            this.constantReflection = constantReflection;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, addressBase, this.cfiTargetRegister}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue(), "Memory access without isolates is not implemented");
            int compressionShift = ReferenceAccess.singleton().getCompressionShift();
            Register computeRegister = ValueUtil.asRegister((Value)this.addressBase);
            AMD64BaseAssembler.OperandSize lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.addressBase.getPlatformKind());
            boolean nextMemoryAccessNeedsDecompress = false;
            for (ComputedIndirectCallTargetNode.Computation computation : this.addressComputation) {
                AMD64Address memoryAddress;
                SharedField field;
                Label done = null;
                if (computation instanceof ComputedIndirectCallTargetNode.FieldLoad) {
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoad)computation).getField();
                    memoryAddress = nextMemoryAccessNeedsDecompress ? new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), computeRegister, Stride.fromLog2((int)compressionShift), field.getOffset()) : new AMD64Address(computeRegister, field.getOffset());
                } else if (computation instanceof ComputedIndirectCallTargetNode.FieldLoadIfZero) {
                    done = new Label();
                    VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Comparison with compressed null value not implemented");
                    masm.cmpAndJcc(lastOperandSize, computeRegister, 0, AMD64Assembler.ConditionFlag.NotEqual, done, true);
                    JavaConstant object = ((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getObject();
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getField();
                    memoryAddress = new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), Register.None, Stride.S1, field.getOffset() + SubstrateAMD64Backend.addressDisplacement(object, this.constantReflection), SubstrateAMD64Backend.addressDisplacementAnnotation(object));
                } else {
                    throw VMError.shouldNotReachHere("Computation is not supported yet: " + computation.getClass().getTypeName());
                }
                switch (field.getStorageKind()) {
                    case Int: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.DWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Long: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.QWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Object: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.lirKindTool.getNarrowOopKind().getPlatformKind());
                        nextMemoryAccessNeedsDecompress = true;
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Kind is not supported yet: " + String.valueOf(field.getStorageKind()));
                    }
                }
                AMD64Assembler.AMD64RMOp.MOV.emit((AMD64Assembler)masm, lastOperandSize, computeRegister, memoryAddress);
                if (done == null) continue;
                masm.bind(done);
            }
            VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Final computed call target address is not a primitive value");
            AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)computeRegister, (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class SubstrateAMD64IndirectCallOp
    extends AMD64Call.IndirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64IndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64IndirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        private final BiConsumer<CompilationResultBuilder, Integer> offsetRecorder;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        private Value[] multipleResults;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        AllocatableValue cfiTargetRegister;
        private SubstrateCallingConventionType callingConventionType;

        public SubstrateAMD64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp, BiConsumer<CompilationResultBuilder, Integer> offsetRecorder) {
            this(callTarget, result, parameters, temps, targetAddress, state, javaFrameAnchor, javaFrameAnchorTemp, newThreadStatus, destroysCallerSavedRegisters, exceptionTemp, offsetRecorder, new Value[0], null);
        }

        public SubstrateAMD64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp, BiConsumer<CompilationResultBuilder, Integer> offsetRecorder, Value[] multipleResults, SubstrateCallingConventionType callingConventionType) {
            super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            this.offsetRecorder = offsetRecorder;
            this.multipleResults = multipleResults;
            this.callingConventionType = callingConventionType;
            this.cfiTargetRegister = SubstrateAMD64Backend.getCFITargetRegister();
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, targetAddress, javaFrameAnchor, javaFrameAnchorTemp, this.cfiTargetRegister}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            int offset = AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, (LIRFrameState)this.state, (CallingConvention.Type)this.callingConventionType);
            if (this.offsetRecorder != null) {
                this.offsetRecorder.accept(crb, offset);
            }
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAMD64DirectCallOp
    extends AMD64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64DirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private AllocatableValue cfiTargetRegister;

        public SubstrateAMD64DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            this.cfiTargetRegister = SubstrateAMD64Backend.getCFITargetRegister();
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, javaFrameAnchor, javaFrameAnchorTemp, this.cfiTargetRegister}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            AMD64Call.directCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (boolean)false, (LIRFrameState)this.state);
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }
}

