/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.gc.WriteBarrierSnippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class BarrierSnippets
extends SubstrateTemplates
implements Snippets {
    public static final LocationIdentity CARD_REMEMBERED_SET_LOCATION = NamedLocationIdentity.mutable((String)"CardRememberedSet");
    private static final SnippetRuntime.SubstrateForeignCallDescriptor POST_WRITE_BARRIER = SnippetRuntime.findForeignCall(BarrierSnippets.class, "postWriteBarrierStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, CARD_REMEMBERED_SET_LOCATION);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAY_RANGE_POST_WRITE_BARRIER = SnippetRuntime.findForeignCall(BarrierSnippets.class, "arrayRangePostWriteBarrierStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, CARD_REMEMBERED_SET_LOCATION);
    private final SnippetTemplate.SnippetInfo postWriteBarrierSnippet;
    private final SnippetTemplate.SnippetInfo arrayRangePostWriteBarrierSnippet;

    BarrierSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.postWriteBarrierSnippet = this.snippet(providers, BarrierSnippets.class, "postWriteBarrierSnippet", new LocationIdentity[]{CARD_REMEMBERED_SET_LOCATION});
        this.arrayRangePostWriteBarrierSnippet = this.snippet(providers, BarrierSnippets.class, "arrayRangePostWriteBarrierSnippet", new LocationIdentity[]{CARD_REMEMBERED_SET_LOCATION});
    }

    public void registerLowerings(MetaAccessProvider metaAccess, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        PostWriteBarrierLowering postWriteBarrierLowering = new PostWriteBarrierLowering(metaAccess);
        lowerings.put(SerialWriteBarrierNode.class, postWriteBarrierLowering);
        ArrayRangePostWriteBarrierLowering arrayRangePostWriteBarrierLowering = new ArrayRangePostWriteBarrierLowering(metaAccess);
        lowerings.put(SerialArrayRangeWriteBarrierNode.class, arrayRangePostWriteBarrierLowering);
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider provider) {
        provider.register(POST_WRITE_BARRIER);
        provider.register(ARRAY_RANGE_POST_WRITE_BARRIER);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void postWriteBarrierStub(Object object, Pointer address) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word objectHeader = oh.readHeaderFromObject(object);
        if (ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)) {
            RememberedSet.get().dirtyCardForUnalignedObject(object, address, false);
        } else {
            RememberedSet.get().dirtyCardForAlignedObject(object, false);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void arrayRangePostWriteBarrierStub(Object object, Pointer startAddress, Pointer endAddress) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word objectHeader = oh.readHeaderFromObject(object);
        if (ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)) {
            RememberedSet.get().dirtyCardRangeForUnalignedObject(object, startAddress, endAddress);
        } else {
            RememberedSet.get().dirtyCardForAlignedObject(object, false);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callPostWriteBarrierStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Pointer var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callArrayRangePostWriteBarrierStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Pointer var2, Pointer var3);

    @Snippet
    public static void postWriteBarrierSnippet(Object object, AddressNode.Address address, @Snippet.ConstantParameter boolean shouldOutline, @Snippet.ConstantParameter boolean precise, @Snippet.ConstantParameter boolean eliminated) {
        boolean unaligned;
        boolean needsBarrier;
        boolean shouldVerify = SerialGCOptions.VerifyWriteBarriers.getValue();
        if (!shouldVerify && eliminated) {
            return;
        }
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word objectHeader = oh.readHeaderFromObject(fixedObject);
        if (shouldVerify && !precise) {
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader))) {
                BreakpointNode.breakpoint();
            }
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (fixedObject == null ? 1 : 0) != 0)) {
                BreakpointNode.breakpoint();
            }
        }
        if (BranchProbabilityNode.probability((double)0.9, (!(needsBarrier = RememberedSet.get().hasRememberedSet((UnsignedWord)objectHeader)) ? 1 : 0) != 0)) {
            return;
        }
        Word addr = Word.fromAddress((AddressNode.Address)address);
        if (shouldOutline && !eliminated) {
            BarrierSnippets.callPostWriteBarrierStub(POST_WRITE_BARRIER, fixedObject, (Pointer)addr);
            return;
        }
        if (precise && BranchProbabilityNode.probability((double)0.4, (boolean)(unaligned = ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)))) {
            RememberedSet.get().dirtyCardForUnalignedObject(fixedObject, (Pointer)addr, eliminated);
            return;
        }
        RememberedSet.get().dirtyCardForAlignedObject(fixedObject, eliminated);
    }

    @Snippet
    public static void arrayRangePostWriteBarrierSnippet(Object object, AddressNode.Address address, long length, @Snippet.ConstantParameter int elementStride, @Snippet.ConstantParameter boolean shouldOutline) {
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (length == 0L ? 1 : 0) != 0)) {
            return;
        }
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word objectHeader = oh.readHeaderFromObject(fixedObject);
        boolean needsBarrier = RememberedSet.get().hasRememberedSet((UnsignedWord)objectHeader);
        if (BranchProbabilityNode.probability((double)0.9, (!needsBarrier ? 1 : 0) != 0)) {
            return;
        }
        Word addr = Word.fromAddress((AddressNode.Address)address);
        Word startAddress = WriteBarrierSnippets.getPointerToFirstArrayElement((Word)addr, (long)length, (int)elementStride);
        Word endAddress = WriteBarrierSnippets.getPointerToLastArrayElement((Word)addr, (long)length, (int)elementStride);
        if (shouldOutline) {
            BarrierSnippets.callArrayRangePostWriteBarrierStub(ARRAY_RANGE_POST_WRITE_BARRIER, fixedObject, (Pointer)startAddress, (Pointer)endAddress);
            return;
        }
        boolean unaligned = ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader);
        if (BranchProbabilityNode.probability((double)0.4, (boolean)unaligned)) {
            RememberedSet.get().dirtyCardRangeForUnalignedObject(fixedObject, (Pointer)startAddress, (Pointer)endAddress);
            return;
        }
        RememberedSet.get().dirtyCardForAlignedObject(fixedObject, false);
    }

    private static boolean shouldOutline(WriteBarrierNode barrier) {
        SerialWriteBarrierNode serialBarrier;
        if (SerialGCOptions.OutlineWriteBarriers.getValue() != null) {
            return SerialGCOptions.OutlineWriteBarriers.getValue();
        }
        if (((Boolean)GraalOptions.ReduceCodeSize.getValue(barrier.getOptions())).booleanValue()) {
            return true;
        }
        return barrier instanceof SerialWriteBarrierNode && (serialBarrier = (SerialWriteBarrierNode)barrier).getBaseStatus().likelyYoung();
    }

    private static boolean tryEliminate(WriteBarrierNode barrier) {
        if (barrier instanceof SerialWriteBarrierNode) {
            SerialWriteBarrierNode serialBarrier = (SerialWriteBarrierNode)barrier;
            return serialBarrier.isEliminated() || serialBarrier.getBaseStatus() == SerialWriteBarrierNode.BaseStatus.NO_LOOP_OR_SAFEPOINT;
        }
        return false;
    }

    private class PostWriteBarrierLowering
    implements NodeLoweringProvider<SerialWriteBarrierNode> {
        private final ResolvedJavaType storedContinuationType;

        PostWriteBarrierLowering(MetaAccessProvider metaAccess) {
            this.storedContinuationType = metaAccess.lookupJavaType(StoredContinuation.class);
        }

        @Override
        public void lower(SerialWriteBarrierNode barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(BarrierSnippets.this.postWriteBarrierSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)address.getBase());
            assert (baseType == null || !this.storedContinuationType.isAssignableFrom(baseType)) : "StoredContinuation should be effectively immutable and references only be written by GC";
            args.add("object", (Object)address.getBase());
            args.add("address", (Object)address);
            args.add("shouldOutline", (Object)BarrierSnippets.shouldOutline((WriteBarrierNode)barrier));
            args.add("precise", (Object)barrier.usePrecise());
            args.add("eliminated", (Object)BarrierSnippets.tryEliminate((WriteBarrierNode)barrier));
            BarrierSnippets.this.template((CoreProviders)tool, (ValueNode)barrier, args).instantiate(tool.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    private class ArrayRangePostWriteBarrierLowering
    implements NodeLoweringProvider<SerialArrayRangeWriteBarrierNode> {
        private final ResolvedJavaType storedContinuationType;

        ArrayRangePostWriteBarrierLowering(MetaAccessProvider metaAccessProvider) {
            this.storedContinuationType = metaAccessProvider.lookupJavaType(StoredContinuation.class);
        }

        @Override
        public void lower(SerialArrayRangeWriteBarrierNode barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(BarrierSnippets.this.arrayRangePostWriteBarrierSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)address.getBase());
            assert (baseType == null || !this.storedContinuationType.isAssignableFrom(baseType)) : "StoredContinuation should be effectively immutable and references only be written by GC";
            args.add("object", (Object)address.getBase());
            args.add("address", (Object)address);
            args.add("length", (Object)barrier.getLengthAsLong());
            args.add("elementStride", (Object)barrier.getElementStride());
            args.add("shouldOutline", (Object)BarrierSnippets.shouldOutline((WriteBarrierNode)barrier));
            BarrierSnippets.this.template((CoreProviders)tool, (ValueNode)barrier, args).instantiate(tool.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

