/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.hpp#L70-L81")
public class VMCommandLineDCmd
extends AbstractDCmd {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMCommandLineDCmd() {
        super("VM.command_line", "Print the command line used to start this VM instance.", DCmd.Impact.Low);
    }

    @Override
    public String execute(DCmdArguments args) throws Throwable {
        String lineBreak = System.lineSeparator();
        StringBuilder result = new StringBuilder("VM Arguments:");
        String[] mainArgs = ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).mainArgs;
        if (mainArgs != null) {
            result.append(lineBreak);
            result.append("java_command: ");
            for (String arg : mainArgs) {
                result.append(arg).append(" ");
            }
        }
        return result.toString();
    }
}

