/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionGroup;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class RuntimeOptionFeature
implements InternalFeature {
    private RuntimeOptionParser runtimeOptionParser;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.runtimeOptionParser = new RuntimeOptionParser();
        ImageSingletons.add(RuntimeOptionParser.class, (Object)this.runtimeOptionParser);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.registerObjectReachableCallback(OptionKey.class, this::collectOptionKeys);
    }

    private void collectOptionKeys(Feature.DuringAnalysisAccess access, OptionKey<?> optionKey, ObjectScanner.ScanReason reason) {
        if (optionKey instanceof HostedOptionKey) {
            return;
        }
        OptionDescriptor optionDescriptor = optionKey.getDescriptor();
        if (optionDescriptor == null) {
            throw VMError.shouldNotReachHere("No OptionDescriptor registered for an OptionKey. Often that is the result of an incomplete build. The registration code is generated by an annotation processor at build time, so a clean and full rebuild often helps to solve this problem");
        }
        OptionGroup group = optionDescriptor.getDeclaringClass().getAnnotation(OptionGroup.class);
        if (group == null || group.registerAsService()) {
            this.runtimeOptionParser.addDescriptor(optionDescriptor);
        }
    }
}

