/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrJdkCompatibility;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.internal.event.Event;
import jdk.jfr.internal.SecuritySupport;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class JfrEventSubstitution
extends SubstitutionProcessor {
    private final ResolvedJavaType baseEventType;
    private final ConcurrentHashMap<ResolvedJavaType, Boolean> typeSubstitution;
    private final ConcurrentHashMap<ResolvedJavaMethod, ResolvedJavaMethod> methodSubstitutions;
    private final ConcurrentHashMap<ResolvedJavaField, ResolvedJavaField> fieldSubstitutions;
    private final Map<String, Class<? extends jdk.jfr.Event>> mirrorEventMapping;
    private static final Method registerMirror = JavaVersionUtil.JAVA_SPEC < 22 ? ReflectionUtil.lookupMethod(SecuritySupport.class, (String)"registerMirror", (Class[])new Class[]{Class.class}) : null;

    JfrEventSubstitution(MetaAccessProvider metaAccess) {
        this.baseEventType = metaAccess.lookupJavaType(Event.class);
        this.typeSubstitution = new ConcurrentHashMap();
        this.methodSubstitutions = new ConcurrentHashMap();
        this.fieldSubstitutions = new ConcurrentHashMap();
        this.mirrorEventMapping = JavaVersionUtil.JAVA_SPEC < 22 ? JfrEventSubstitution.createMirrorEventsMapping() : null;
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        ResolvedJavaType type = field.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.fieldSubstitutions.computeIfAbsent(field, JfrEventSubstitution::initEventField);
        }
        return field;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaType type = method.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.methodSubstitutions.computeIfAbsent(method, JfrEventSubstitution::initEventMethod);
        }
        return method;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
        }
        return type;
    }

    private static ResolvedJavaField initEventField(ResolvedJavaField oldField) throws RuntimeException {
        ResolvedJavaType type = oldField.getDeclaringClass();
        if (oldField.isStatic()) {
            for (ResolvedJavaField field : type.getStaticFields()) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        } else {
            for (ResolvedJavaField field : type.getInstanceFields(false)) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        }
        throw VMError.shouldNotReachHere("Could not re-resolve field: " + String.valueOf(oldField));
    }

    private static ResolvedJavaMethod initEventMethod(ResolvedJavaMethod oldMethod) throws RuntimeException {
        ResolvedJavaMethod newMethod;
        ResolvedJavaType type = oldMethod.getDeclaringClass();
        String name = oldMethod.getName();
        Signature signature = oldMethod.getSignature();
        if (name.equals("<clinit>")) {
            return type.getClassInitializer();
        }
        if (name.equals("<init>")) {
            for (ResolvedJavaMethod m : type.getDeclaredConstructors(false)) {
                if (!m.getName().equals(name) || !m.getSignature().equals((Object)signature)) continue;
                return m;
            }
        }
        if ((newMethod = type.findMethod(name, signature)) != null) {
            return newMethod;
        }
        throw VMError.shouldNotReachHere("Could not re-resolve method: " + String.valueOf(oldMethod));
    }

    private Boolean initEventClass(ResolvedJavaType eventType) throws RuntimeException {
        try {
            Class<? extends jdk.jfr.Event> mirrorEventClass;
            Class<Event> newEventClass = OriginalClassProvider.getJavaClass((JavaType)eventType).asSubclass(Event.class);
            eventType.initialize();
            if (JavaVersionUtil.JAVA_SPEC < 22 && (mirrorEventClass = this.mirrorEventMapping.get(newEventClass.getName())) != null) {
                registerMirror.invoke(null, mirrorEventClass);
            }
            SecuritySupport.registerEvent(newEventClass);
            JfrJavaEvents.registerEventClass(newEventClass);
            JfrJdkCompatibility.retransformClasses(new Class[]{newEventClass});
            return Boolean.TRUE;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private boolean needsClassRedefinition(ResolvedJavaType type) {
        return !type.isAbstract() && this.baseEventType.isAssignableFrom(type) && !this.baseEventType.equals((Object)type);
    }

    private static Map<String, Class<? extends jdk.jfr.Event>> createMirrorEventsMapping() {
        ConcurrentMap<String, Class<? extends jdk.jfr.Event>> result = ObservableImageHeapMapProvider.create();
        Class mirrorEventAnnotationClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.jfr.internal.MirrorEvent");
        Class jdkEventsClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.jfr.internal.instrument.JDKEvents");
        Class[] mirrorEventClasses = (Class[])ReflectionUtil.readStaticField((Class)jdkEventsClass, (String)"mirrorEventClasses");
        for (int i = 0; i < mirrorEventClasses.length; ++i) {
            Class mirrorEventClass = mirrorEventClasses[i];
            Annotation mirrorEvent = AnnotationAccess.getAnnotation((AnnotatedElement)mirrorEventClass, (Class)mirrorEventAnnotationClass);
            Method m = ReflectionUtil.lookupMethod((Class)mirrorEventAnnotationClass, (String)"className", (Class[])new Class[0]);
            try {
                String className = (String)m.invoke((Object)mirrorEvent, new Object[0]);
                result.put(className, mirrorEventClass);
                continue;
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        return result;
    }
}

