/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedMethodNameFactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

public class HostedDynamicLayerInfo
extends DynamicImageLayerInfo
implements LayeredImageSingleton {
    private final Map<Integer, Integer> methodIdToOffsetMap;
    private final ConcurrentHashMap<Integer, HostedMethodNameFactory.MethodNameInfo> methodIdToNameInfoMap;
    private final CGlobalData<PointerBase> cGlobalData;
    private final Set<String> priorLayerMethodSymbols = new HashSet<String>();
    private final List<String> libNames;
    private boolean persisted = false;

    HostedDynamicLayerInfo() {
        this(0, null, new HashMap<Integer, Integer>(), new ConcurrentHashMap<Integer, HostedMethodNameFactory.MethodNameInfo>(), new ArrayList<String>());
    }

    public static HostedDynamicLayerInfo singleton() {
        return (HostedDynamicLayerInfo)ImageSingletons.lookup(DynamicImageLayerInfo.class);
    }

    private HostedDynamicLayerInfo(int layerNumber, String codeSectionStartSymbol, Map<Integer, Integer> methodIdToOffsetMap, ConcurrentHashMap<Integer, HostedMethodNameFactory.MethodNameInfo> methodIdToNameInfoMap, List<String> libNames) {
        super(layerNumber);
        this.methodIdToOffsetMap = methodIdToOffsetMap;
        this.methodIdToNameInfoMap = methodIdToNameInfoMap;
        this.libNames = libNames;
        this.cGlobalData = codeSectionStartSymbol == null ? null : CGlobalDataFactory.forSymbol(codeSectionStartSymbol);
    }

    @Override
    public DynamicImageLayerInfo.PriorLayerMethodLocation getPriorLayerMethodLocation(SharedMethod sMethod) {
        assert (ImageLayerBuildingSupport.buildingExtensionLayer()) : "This should only be called within extension images. Within the initial layer the direct calls can be performed";
        HostedMethod method = (HostedMethod)sMethod;
        assert (method.wrapped.isInBaseLayer() && this.methodIdToOffsetMap.containsKey(method.getWrapped().getId())) : method;
        CGlobalDataInfo basePointer = CGlobalDataFeature.singleton().registerAsAccessedOrGet(this.cGlobalData);
        Integer offset = this.methodIdToOffsetMap.get(method.getWrapped().getId());
        return new DynamicImageLayerInfo.PriorLayerMethodLocation(basePointer, offset);
    }

    public boolean compiledInPriorLayer(AnalysisMethod aMethod) {
        assert (!BuildPhaseProvider.isCompileQueueFinished());
        return this.methodIdToOffsetMap.containsKey(aMethod.getId());
    }

    public HostedMethodNameFactory.MethodNameInfo loadMethodNameInfo(AnalysisMethod method) {
        return this.methodIdToNameInfoMap.get(method.getId());
    }

    public void recordPersistedMethod(HostedMethod hMethod) {
        assert (!this.persisted) : "Too late to record this information";
        HostedMethodNameFactory.MethodNameInfo info = new HostedMethodNameFactory.MethodNameInfo(hMethod.getName(), hMethod.getUniqueShortName());
        HostedMethodNameFactory.MethodNameInfo prev = this.methodIdToNameInfoMap.put(hMethod.getWrapped().getId(), info);
        assert (prev == null) : prev;
    }

    public Set<String> getReservedNames() {
        return this.methodIdToNameInfoMap.values().stream().map(HostedMethodNameFactory.MethodNameInfo::uniqueShortName).collect(Collectors.toUnmodifiableSet());
    }

    void registerCompilation(HostedMethod method) {
        assert (BuildPhaseProvider.isCompileQueueFinished());
        int offset = method.getCodeAddressOffset();
        int methodID = method.getWrapped().getId();
        assert (!this.methodIdToOffsetMap.containsKey(methodID)) : Assertions.errorMessage((Object[])new Object[]{"Duplicate entry", methodID, offset});
        this.methodIdToOffsetMap.put(methodID, offset);
    }

    public void registerHostedMethod(HostedMethod hMethod) {
        assert (!BuildPhaseProvider.isHostedUniverseBuilt());
        AnalysisMethod aMethod = hMethod.getWrapped();
        if (this.compiledInPriorLayer(aMethod)) {
            assert (aMethod.isInBaseLayer()) : hMethod;
            this.priorLayerMethodSymbols.add(NativeImage.localSymbolNameForMethod(hMethod));
            hMethod.setCompiledInPriorLayer();
        }
    }

    public void defineSymbolsForPriorLayerMethods(ObjectFile objectFile) {
        assert (BuildPhaseProvider.isHeapLayoutFinished());
        this.priorLayerMethodSymbols.forEach(symbol -> objectFile.createUndefinedSymbol(symbol, 0, true));
    }

    public void registerLibName(String lib) {
        this.libNames.add(lib);
    }

    public boolean isImageLayerLib(String lib) {
        return this.libNames.contains(lib);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    boolean verifyUniqueOffsets(Collection<? extends SharedMethod> methods) {
        BitSet seenOffsets = new BitSet();
        for (Map.Entry<Integer, Integer> entry : this.methodIdToOffsetMap.entrySet()) {
            if (seenOffsets.get(entry.getValue())) {
                Optional<SharedMethod> method = methods.stream().filter(m -> ((HostedMethod)m).getWrapped().getId() == ((Integer)entry.getKey()).intValue()).findAny();
                assert (false) : Assertions.errorMessage((Object[])new Object[]{"Value has already been found", method, entry.getKey(), entry.getValue()});
            }
            seenOffsets.set(entry.getValue());
        }
        return true;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        this.persisted = true;
        assert (ImageLayerBuildingSupport.buildingInitialLayer()) : "This code must be adjusted to support multiple shared layers";
        writer.writeInt("nextLayerNumber", this.nextLayerNumber);
        writer.writeString("codeSectionStartSymbol", NativeImage.getTextSectionStartSymbol());
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.methodIdToOffsetMap.size());
        ArrayList<Integer> methodOffsetIds = new ArrayList<Integer>(this.methodIdToOffsetMap.size());
        this.methodIdToOffsetMap.forEach((key, value) -> {
            methodOffsetIds.add((Integer)key);
            offsets.add((Integer)value);
        });
        writer.writeIntList("methodOffsetIDs", methodOffsetIds);
        writer.writeIntList("offsets", offsets);
        ArrayList<Integer> methodNameIds = new ArrayList<Integer>(this.methodIdToNameInfoMap.size());
        ArrayList<String> names = new ArrayList<String>(this.methodIdToNameInfoMap.size() * 2);
        this.methodIdToNameInfoMap.forEach((key, value) -> {
            methodNameIds.add((Integer)key);
            names.add(value.name());
            names.add(value.uniqueShortName());
        });
        writer.writeIntList("methodNameIDs", methodNameIds);
        writer.writeStringList("names", names);
        writer.writeStringList("libNames", this.libNames);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        assert (loader.readIntList("offsets").size() == loader.readIntList("methodOffsetIDs").size()) : Assertions.errorMessage((Object[])new Object[]{"Offsets and methodIDs are incompatible", loader.readIntList("offsets"), loader.readIntList("methodIDs")});
        int layerNumber = loader.readInt("nextLayerNumber");
        String codeSectionStartSymbol = loader.readString("codeSectionStartSymbol");
        Iterator<Integer> offsets = loader.readIntList("offsets").iterator();
        Iterator<Integer> methodOffsetIds = loader.readIntList("methodOffsetIDs").iterator();
        HashMap<Integer, Integer> initialMethodIdToOffsetMap = new HashMap<Integer, Integer>();
        while (offsets.hasNext()) {
            int methodId = methodOffsetIds.next();
            int offset = offsets.next();
            Integer prev = initialMethodIdToOffsetMap.put(methodId, offset);
            assert (prev == null);
        }
        Iterator<String> names = loader.readStringList("names").iterator();
        Iterator<Integer> methodNameIds = loader.readIntList("methodNameIDs").iterator();
        ConcurrentHashMap<Integer, HostedMethodNameFactory.MethodNameInfo> initialMethodIdToMethodNameMap = new ConcurrentHashMap<Integer, HostedMethodNameFactory.MethodNameInfo>();
        while (methodNameIds.hasNext()) {
            int methodId = methodNameIds.next();
            String name = names.next();
            String uniqueShortName = names.next();
            HostedMethodNameFactory.MethodNameInfo prev = initialMethodIdToMethodNameMap.put(methodId, new HostedMethodNameFactory.MethodNameInfo(name, uniqueShortName));
            assert (prev == null);
        }
        List<String> libNames = loader.readStringList("libNames");
        return new HostedDynamicLayerInfo(layerNumber, codeSectionStartSymbol, initialMethodIdToOffsetMap, initialMethodIdToMethodNameMap, libNames);
    }
}

