/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LLVMToolchain {
    public static String runLLVMCommand(String command, Path directory, String ... args) throws RunFailureException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(LLVMToolchain.getLLVMBinDir().resolve(command).toString());
        Collections.addAll(cmd, args);
        return LLVMToolchain.runCommand(directory, cmd);
    }

    public static String runLLVMCommand(String command, Path directory, List<String> args) throws RunFailureException {
        ArrayList<String> cmd = new ArrayList<String>(args);
        cmd.add(0, LLVMToolchain.getLLVMBinDir().resolve(command).toString());
        return LLVMToolchain.runCommand(directory, cmd);
    }

    public static String runCommand(Path directory, List<String> cmd) throws RunFailureException {
        int status;
        String output;
        Process llvmProcess = null;
        try {
            ProcessBuilder llvmCommand = FileUtils.prepareCommand(cmd, directory);
            llvmCommand.redirectErrorStream(true);
            FileUtils.traceCommand(llvmCommand);
            llvmProcess = llvmCommand.start();
            try (InputStream inputStream = llvmProcess.getInputStream();){
                List<String> lines = FileUtils.readAllLines(inputStream);
                FileUtils.traceCommandOutput(lines);
                output = String.join((CharSequence)System.lineSeparator(), lines);
            }
            status = llvmProcess.waitFor();
        }
        catch (IOException e) {
            status = -1;
            output = e.getMessage();
        }
        catch (InterruptedException e) {
            String commandLine = SubstrateUtil.getShellCommandString(cmd, false);
            throw new InterruptImageBuilding("Interrupted during llvm command execution: " + commandLine);
        }
        finally {
            if (llvmProcess != null) {
                llvmProcess.destroy();
            }
        }
        if (status != 0) {
            throw new RunFailureException(status, output);
        }
        return output;
    }

    public static Path getLLVMBinDir() {
        String property = System.getProperty("llvm.bin.dir");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        Path runtimeDir = BuildDirectoryProvider.singleton().getHome();
        if (runtimeDir == null) {
            throw new IllegalStateException("Could not find java.home");
        }
        if (System.getProperty("java.specification.version").startsWith("1.")) {
            runtimeDir = runtimeDir.resolve("jre");
        }
        return runtimeDir.resolve("lib").resolve("llvm").resolve("bin");
    }

    public static final class RunFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int status;
        private String output;

        private RunFailureException(int status, String output) {
            this.status = status;
            this.output = output;
        }

        public int getStatus() {
            return this.status;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

