/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.image.DisallowedImageHeapObjects;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.management.PlatformManagedObject;
import java.lang.ref.Cleaner;
import java.nio.Buffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.zip.ZipFile;
import javax.management.MBeanServerConnection;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class DisallowedImageHeapObjectFeature
implements InternalFeature {
    private ClassInitializationSupport classInitialization;
    private String[] disallowedSubstrings;
    private Map<byte[], Charset> disallowedByteSubstrings;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitialization = access.getHostVM().getClassInitializationSupport();
        access.registerObjectReachableCallback(MBeanServerConnection.class, (a1, obj, reason) -> DisallowedImageHeapObjectFeature.onMBeanServerConnectionReachable(obj, this::error));
        access.registerObjectReachableCallback(PlatformManagedObject.class, (a1, obj, reason) -> DisallowedImageHeapObjectFeature.onPlatformManagedObjectReachable(obj, this::error));
        access.registerObjectReachableCallback(Random.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onRandomReachable(obj, this::error));
        access.registerObjectReachableCallback(SplittableRandom.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onSplittableRandomReachable(obj, this::error));
        access.registerObjectReachableCallback(Thread.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onThreadReachable(obj, this::error));
        access.registerObjectReachableCallback(DisallowedImageHeapObjects.CONTINUATION_CLASS, (a1, obj, reason) -> DisallowedImageHeapObjects.onContinuationReachable(obj, this::error));
        access.registerObjectReachableCallback(FileDescriptor.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onFileDescriptorReachable(obj, this::error));
        access.registerObjectReachableCallback(Buffer.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onBufferReachable(obj, this::error));
        access.registerObjectReachableCallback(Cleaner.Cleanable.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onCleanableReachable(obj, this::error));
        access.registerObjectReachableCallback(DisallowedImageHeapObjects.LEGACY_CLEANER_CLASS, (a1, obj, reason) -> DisallowedImageHeapObjects.onCleanableReachable(obj, this::error));
        access.registerObjectReachableCallback(Cleaner.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onCleanerReachable(obj, this::error));
        access.registerObjectReachableCallback(ZipFile.class, (a1, obj, reason) -> DisallowedImageHeapObjects.onZipFileReachable(obj, this::error));
        access.registerObjectReachableCallback(DisallowedImageHeapObjects.CANCELLABLE_CLASS, (a1, obj, reason) -> DisallowedImageHeapObjects.onCancellableReachable(obj, this::error));
        if (SubstrateOptions.DetectUserDirectoriesInImageHeap.getValue().booleanValue()) {
            access.registerObjectReachableCallback(String.class, this::onStringReachable);
            access.registerObjectReachableCallback(byte[].class, this::onByteArrayReachable);
            this.disallowedSubstrings = DisallowedImageHeapObjectFeature.getDisallowedSubstrings(System.getProperty("user.home"), System.getProperty("user.dir"), System.getProperty("java.home"));
            HashSet<Charset> encodings = new HashSet<Charset>(Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.UTF_16, Charset.forName(System.getProperty("sun.jnu.encoding"))));
            this.disallowedByteSubstrings = new IdentityHashMap<byte[], Charset>();
            for (String s : this.disallowedSubstrings) {
                for (Charset encoding : encodings) {
                    this.disallowedByteSubstrings.put(s.getBytes(encoding), encoding);
                }
            }
        }
    }

    private static String[] getDisallowedSubstrings(String ... substrings) {
        return (String[])Arrays.stream(substrings).filter(s -> s.indexOf(File.separatorChar, s.indexOf(File.separatorChar) + 1) != -1).toArray(String[]::new);
    }

    private void onStringReachable(Feature.DuringAnalysisAccess a, String string, ObjectScanner.ScanReason reason) {
        if (this.disallowedSubstrings != null) {
            for (String disallowedSubstring : this.disallowedSubstrings) {
                if (!string.contains(disallowedSubstring)) continue;
                throw new UnsupportedFeatureException("Detected a string in the image heap that contains a user directory. This means that file system information from the native image build is persisted and available at image runtime, which is most likely an error." + System.lineSeparator() + "String that is problematic: " + string + System.lineSeparator() + "Disallowed substring with user directory: " + disallowedSubstring + System.lineSeparator() + "This check can be disabled using the option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DetectUserDirectoriesInImageHeap, "-"));
            }
        }
    }

    private void onByteArrayReachable(Feature.DuringAnalysisAccess a, byte[] bytes, ObjectScanner.ScanReason reason) {
        if (this.disallowedByteSubstrings != null) {
            for (Map.Entry<byte[], Charset> entry : this.disallowedByteSubstrings.entrySet()) {
                byte[] disallowedSubstring = entry.getKey();
                if (!DisallowedImageHeapObjectFeature.search(bytes, disallowedSubstring)) continue;
                Charset charset = entry.getValue();
                throw new UnsupportedFeatureException("Detected a byte[] in the image heap that contains a user directory. This means that file system information from the native image build is persisted and available at image runtime, which is most likely an error." + System.lineSeparator() + "byte[] that is problematic: " + new String(bytes, charset) + System.lineSeparator() + "Disallowed substring with user directory: " + new String(disallowedSubstring, charset) + System.lineSeparator() + "This check can be disabled using the option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DetectUserDirectoriesInImageHeap, "-"));
            }
        }
    }

    private static void onMBeanServerConnectionReachable(MBeanServerConnection serverConnection, DisallowedImageHeapObjects.DisallowedObjectReporter reporter) {
        throw reporter.raise("Detected a MBean server in the image heap. This is currently not supported, but could be changed in the future. Management beans are registered in many global caches that would need to be cleared and properly re-built at image build time. Class of disallowed object: " + serverConnection.getClass().getTypeName(), serverConnection, "Try to avoid initializing the class that stores a MBean server or a MBean in a static field");
    }

    private static void onPlatformManagedObjectReachable(PlatformManagedObject platformManagedObject, DisallowedImageHeapObjects.DisallowedObjectReporter reporter) {
        if (!ManagementSupport.getSingleton().isAllowedPlatformManagedObject(platformManagedObject)) {
            throw reporter.raise("Detected a PlatformManagedObject (a MXBean defined by the virtual machine) in the image heap. This bean is introspecting the VM that runs the image builder, i.e., a VM instance that is no longer available at image runtime. Class of disallowed object: " + platformManagedObject.getClass().getTypeName(), platformManagedObject, "Try to avoid initializing the class that stores the object in a static field");
        }
    }

    private RuntimeException error(String msg, Object obj, String initializerAction) {
        throw new UnsupportedFeatureException(msg + " " + this.classInitialization.objectInstantiationTraceMessage(obj, "", action -> initializerAction) + "The object was probably created by a class initializer and is reachable from a static field. You can request class initialization at image runtime by using the option " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<class-name>", "initialize-at-run-time") + ". Or you can write your own initialization methods and call them explicitly from your main entry point.");
    }

    private static boolean search(byte[] haystack, byte[] needle) {
        byte first = needle[0];
        for (int start = 0; start < haystack.length - needle.length; ++start) {
            if (haystack[start] != first) continue;
            boolean same = true;
            for (int i = 1; i < needle.length; ++i) {
                if (haystack[start + i] == needle[i]) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return true;
        }
        return false;
    }
}

