/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.windows.headers.Process;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class WindowsVMMutex
extends VMMutex {
    private final CIsolateData<Process.CRITICAL_SECTION> structPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsVMMutex(String name) {
        super(name);
        this.structPointer = CIsolateDataFactory.createStruct("windowsMutex_" + name, Process.CRITICAL_SECTION.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Process.PCRITICAL_SECTION getStructPointer() {
        return (Process.PCRITICAL_SECTION)((Object)this.structPointer.get());
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        Process.NoTransitions.InitializeCriticalSection(this.getStructPointer());
        return 0;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        Process.NoTransitions.DeleteCriticalSection(this.getStructPointer());
        return 0;
    }

    @Override
    public VMMutex lock() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        Process.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransition() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        Process.NoTransitions.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        Process.NoTransitions.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        this.clearCurrentThreadOwner();
        Process.NoTransitions.LeaveCriticalSection(this.getStructPointer());
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.")
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
        Process.NoTransitions.LeaveCriticalSection(this.getStructPointer());
    }
}

