/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.stack.SubstrateInspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class PhysicalStackFrameVisitor<T>
extends StackFrameVisitor {
    private ResolvedJavaMethod[] curMatchingMethods;
    private final ResolvedJavaMethod[] laterMatchingMethods;
    private int skip;
    private final InspectedFrameVisitor<T> visitor;
    protected T result;

    PhysicalStackFrameVisitor(ResolvedJavaMethod[] initialMethods, ResolvedJavaMethod[] matchingMethods, int initialSkip, InspectedFrameVisitor<T> visitor) {
        this.curMatchingMethods = initialMethods;
        this.laterMatchingMethods = matchingMethods;
        this.skip = initialSkip;
        this.visitor = visitor;
    }

    @Override
    public boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
        return this.visitFrame(sp, ip, codeInfo, null);
    }

    @Override
    protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
        CodeInfo imageCodeInfo = CodeInfoTable.lookupImageCodeInfo(deoptStubIP);
        return this.visitFrame(originalSP, deoptStubIP, imageCodeInfo, deoptimizedFrame);
    }

    private boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
        DeoptimizedFrame.VirtualFrame virtualFrame = null;
        CodeInfoQueryResult info = null;
        FrameInfoQueryResult deoptInfo = null;
        if (deoptimizedFrame != null) {
            virtualFrame = deoptimizedFrame.getTopFrame();
        } else {
            info = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip);
            if (info == null || info.getFrameInfo() == null) {
                return true;
            }
            deoptInfo = info.getFrameInfo();
        }
        int virtualFrameIndex = 0;
        do {
            CodePointer deoptAddress;
            if (virtualFrame != null) {
                assert (deoptInfo == null) : "must have either deoptimized or non-deoptimized frame information, but not both";
                deoptAddress = virtualFrame.getFrameInfo().getDeoptMethodAddress();
            } else {
                deoptAddress = deoptInfo.getDeoptMethodAddress();
            }
            if (PhysicalStackFrameVisitor.matchesDeoptAddress(deoptAddress, this.curMatchingMethods)) {
                if (this.skip > 0) {
                    --this.skip;
                } else {
                    SubstrateInspectedFrame inspectedFrame = new SubstrateInspectedFrame(sp, ip, virtualFrame, info, deoptInfo, virtualFrameIndex);
                    this.result = this.visitor.visitFrame((InspectedFrame)inspectedFrame);
                    if (this.result != null) {
                        return false;
                    }
                    if (virtualFrame == null && inspectedFrame.virtualFrame != null) {
                        virtualFrame = inspectedFrame.virtualFrame;
                        deoptInfo = null;
                    }
                    this.curMatchingMethods = this.laterMatchingMethods;
                }
            }
            if (virtualFrame != null) {
                virtualFrame = virtualFrame.getCaller();
            } else {
                deoptInfo = deoptInfo.getCaller();
            }
            ++virtualFrameIndex;
        } while (virtualFrame != null || deoptInfo != null);
        return true;
    }

    private static boolean matchesDeoptAddress(CodePointer ip, ResolvedJavaMethod[] methods) {
        if (methods == null) {
            return true;
        }
        for (ResolvedJavaMethod method : methods) {
            CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo((SharedMethod)method);
            if (ip != CodeInfoAccess.absoluteIP(codeInfo, ((SharedMethod)method).getImageCodeDeoptOffset())) continue;
            return true;
        }
        return false;
    }
}

