/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.MissingRegistrationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.MissingJNIRegistrationError;

public final class MissingJNIRegistrationUtils {
    public static void forClass(String className) {
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.errorMessage("access class", className), Class.class, null, className, null);
        MissingJNIRegistrationUtils.report(exception);
    }

    public static void forField(Class<?> declaringClass, String fieldName) {
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.errorMessage("access field", declaringClass.getTypeName() + "#" + fieldName), Field.class, declaringClass, fieldName, null);
        MissingJNIRegistrationUtils.report(exception);
    }

    public static void forMethod(Class<?> declaringClass, String methodName, String signature) {
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.errorMessage("access method", declaringClass.getTypeName() + "#" + methodName + signature), Method.class, declaringClass, methodName, signature);
        MissingJNIRegistrationUtils.report(exception);
    }

    private static String errorMessage(String failedAction, String elementDescriptor) {
        return MissingJNIRegistrationUtils.errorMessage(failedAction, elementDescriptor, null, "JNI");
    }

    private static String errorMessage(String failedAction, String elementDescriptor, String note, String helpLink) {
        return "The program tried to reflectively " + failedAction + System.lineSeparator() + System.lineSeparator() + "   " + elementDescriptor + System.lineSeparator() + System.lineSeparator() + "without it being registered for runtime JNI access. Add " + elementDescriptor + " to the " + helpLink + " metadata to solve this problem. " + (String)(note != null ? "Note: " + note + " " : "") + "See https://www.graalvm.org/latest/reference-manual/native-image/metadata/#" + helpLink + " for help.";
    }

    private static void report(MissingJNIRegistrationError exception) {
        MissingRegistrationUtils.report((Error)exception, null);
    }
}

