/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;

public final class ModuleNative {
    private static final String PACKAGE_TAG = "module";
    private static final String MODULE_TAG = "module";
    private static final String FROM_MODULE_TAG = "from_module";
    private static final String TO_MODULE_TAG = "to_module";
    private static final Object moduleLock = new Object();
    private static final Map<ClassLoader, Set<Module>> definedModules = new HashMap<ClassLoader, Set<Module>>();

    private ModuleNative() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineModule(Module module, boolean isOpen, Object[] pns) {
        boolean moduleAlreadyDefined;
        if (Objects.isNull(module)) {
            throw new NullPointerException("Null module object");
        }
        if (Objects.isNull(module.getName())) {
            throw new IllegalArgumentException("Module name cannot be null");
        }
        if (module.getName().equals("java.base")) {
            if (isOpen) {
                throw new AssertionError((Object)"java.base module cannot be open");
            }
            for (Object pn : pns) {
                ModuleNative.checkPackageNameForModule(pn, "java.base");
            }
            if (module.getClassLoader() != null) {
                throw new IllegalArgumentException("Class loader must be the boot class loader");
            }
            Object object = moduleLock;
            synchronized (object) {
                boolean duplicateJavaBase = ModuleNative.bootLayerContainsModule("java.base");
                if (duplicateJavaBase) {
                    throw new InternalError("Module java.base is already defined");
                }
            }
            return;
        }
        ClassLoader classLoader = module.getClassLoader();
        if (Objects.nonNull(classLoader) && classLoader.getClass().getName().equals("jdk.internal.reflect.DelegatingClassLoader")) {
            throw new IllegalArgumentException("Class loader is an invalid delegating class loader");
        }
        boolean javaPkgDisallowed = !Objects.isNull(classLoader) && !Objects.equals(classLoader, ClassLoader.getPlatformClassLoader());
        for (Object pn : pns) {
            ModuleNative.checkPackageNameForModule(pn, module.getName());
            if (!javaPkgDisallowed || !ModuleNative.isPackageNameForbidden(pn.toString())) continue;
            throw new IllegalArgumentException("Class loader (instance of): " + classLoader.getClass().getName() + " tried to define prohibited package name: " + String.valueOf(pn));
        }
        String definedPackage = null;
        Object object = moduleLock;
        synchronized (object) {
            moduleAlreadyDefined = ModuleNative.isModuleDefinedToLoader(classLoader, module.getName());
            if (!moduleAlreadyDefined) {
                List<String> definedPackages = ModuleNative.getPackagesDefinedToLoader(classLoader);
                for (Object pn : pns) {
                    String pnString = pn.toString();
                    if (!definedPackages.contains(pnString)) continue;
                    definedPackage = pnString;
                    break;
                }
            }
        }
        if (moduleAlreadyDefined) {
            throw new IllegalStateException("Module " + module.getName() + " is already defined");
        }
        if (Objects.nonNull(definedPackage)) {
            Module moduleContainingDefinedPackage = SubstrateUtil.cast(ModuleNative.getModuleContainingPackage(classLoader, definedPackage), Module.class);
            if (moduleContainingDefinedPackage.isNamed()) {
                throw new IllegalStateException("Package " + definedPackage + " is already in another module, " + moduleContainingDefinedPackage.getName() + ", defined to the class loader");
            }
            throw new IllegalStateException("Package " + definedPackage + " is already in the unnamed module defined to the class loader");
        }
        object = moduleLock;
        synchronized (object) {
            ModuleNative.addDefinedModule(classLoader, module);
        }
    }

    public static void addReads(Module from, Module to) {
        ModuleNative.checkIsNull(from, FROM_MODULE_TAG);
    }

    public static void addExports(Module from, String pn, Module to) {
        ModuleNative.checkIsNull(to, TO_MODULE_TAG);
        ModuleNative.addExportsToAll(from, pn);
    }

    public static void addExportsToAll(Module from, String pn) {
        ModuleNative.checkIsNull(pn, "module");
        ModuleNative.checkIsNull(from, FROM_MODULE_TAG);
        ModuleNative.checkIsPackageContainedInModule(pn, from, FROM_MODULE_TAG);
    }

    public static void addExportsToAllUnnamed(Module module, String pn) {
        ModuleNative.checkIsNull(module, "module");
        ModuleNative.checkIsNull(pn, "module");
        ModuleNative.checkIsPackageContainedInModule(pn, module, "module");
    }

    private static Map<ClassLoader, Set<Module>> getDefinedModules() {
        if (definedModules.isEmpty()) {
            for (Module module : ModuleLayer.boot().modules()) {
                Set<Module> modules = definedModules.get(module.getClassLoader());
                if (Objects.isNull(modules)) {
                    modules = new HashSet<Module>();
                    modules.add(module);
                    definedModules.put(module.getClassLoader(), modules);
                    continue;
                }
                modules.add(module);
            }
        }
        return definedModules;
    }

    private static void checkIsNull(Object o, String tag) {
        if (Objects.isNull(o)) {
            throw new NullPointerException(tag + " is null");
        }
    }

    private static boolean isPackageNameForbidden(String pn) {
        if (!pn.startsWith("java")) {
            return false;
        }
        int trailingChar = pn.length() < 5 ? 46 : (int)pn.charAt("java".length());
        return trailingChar == 46;
    }

    private static void checkPackageNameForModule(Object pn, String module) {
        if (Objects.isNull(pn) || !(pn instanceof String)) {
            throw new IllegalArgumentException("Bad package name");
        }
        String pnString = (String)pn;
        if (!SourceVersion.isName(pnString)) {
            throw new IllegalArgumentException("Invalid package name: " + pnString + " for module: " + module);
        }
    }

    private static boolean isModuleDefinedToLoader(ClassLoader loader, String moduleName) {
        return ModuleNative.getDefinedModules().getOrDefault(loader, Set.of()).stream().anyMatch(m -> m.getName().equals(moduleName));
    }

    private static void addDefinedModule(ClassLoader loader, Module module) {
        Set<Module> modules = ModuleNative.getDefinedModules().get(loader);
        if (Objects.isNull(modules)) {
            modules = new HashSet<Module>();
            modules.add(module);
            ModuleNative.getDefinedModules().put(loader, modules);
        } else {
            modules.add(module);
        }
    }

    private static void checkIsPackageContainedInModule(String pn, Module module, String tag) {
        if (!module.isNamed() || module.getDescriptor().isOpen()) {
            return;
        }
        if (!module.getPackages().contains(pn)) {
            throw new IllegalArgumentException("Package " + pn + " not found in " + tag + " " + module.getName());
        }
    }

    private static List<String> getPackagesDefinedToLoader(ClassLoader loader) {
        return ModuleNative.getDefinedModules().getOrDefault(loader, Set.of()).stream().flatMap(m -> m.getPackages().stream()).toList();
    }

    private static Object getModuleContainingPackage(ClassLoader loader, String pn) {
        return ModuleNative.getDefinedModules().getOrDefault(loader, Set.of()).stream().filter(m -> m.getPackages().contains(pn)).findFirst().orElse(null);
    }

    public static boolean bootLayerContainsModule(String name) {
        return ModuleLayer.boot().modules().stream().anyMatch(m -> m.getName().equals(name));
    }
}

