/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class HostedImageHeapChunkWriter
implements ImageHeapChunkWriter {
    private final ByteBuffer buffer;
    private final int layoutToBufferAddend;
    private final int headerSize;
    private final int topOffsetAt;
    private final int endOffsetAt;
    private final int spaceOffsetAt;
    private final int offsetToPreviousChunkAt;
    private final int offsetToNextChunkAt;
    private final RememberedSet rememberedSet = RememberedSet.get();

    HostedImageHeapChunkWriter(ByteBuffer heapBuffer, long layoutToBufferOffsetAddend) {
        this.buffer = heapBuffer;
        this.layoutToBufferAddend = NumUtil.safeToInt((long)layoutToBufferOffsetAddend);
        this.headerSize = SizeOf.get(HeapChunk.Header.class);
        this.topOffsetAt = OffsetOf.get(HeapChunk.Header.class, "TopOffset");
        this.endOffsetAt = OffsetOf.get(HeapChunk.Header.class, "EndOffset");
        this.spaceOffsetAt = OffsetOf.get(HeapChunk.Header.class, "Space");
        this.offsetToPreviousChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToPreviousChunk");
        this.offsetToNextChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToNextChunk");
    }

    private int getChunkOffsetInBuffer(int chunkPosition) {
        return chunkPosition + this.layoutToBufferAddend;
    }

    @Override
    public void initializeAlignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.writeHeader(chunkOffset, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
    }

    @Override
    public void initializeUnalignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.writeHeader(chunkOffset, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
    }

    private void writeHeader(int chunkOffset, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        for (int i = 0; i < this.headerSize; ++i) {
            assert (this.buffer.get(chunkOffset + i) == 0) : "Header area must be zeroed out";
        }
        this.buffer.putLong(chunkOffset + this.topOffsetAt, topOffset);
        this.buffer.putLong(chunkOffset + this.endOffsetAt, endOffset);
        HostedImageHeapChunkWriter.putObjectReference(this.buffer, chunkOffset + this.spaceOffsetAt, 0L);
        this.buffer.putLong(chunkOffset + this.offsetToPreviousChunkAt, offsetToPreviousChunk);
        this.buffer.putLong(chunkOffset + this.offsetToNextChunkAt, offsetToNextChunk);
    }

    @Override
    public void enableRememberedSetForAlignedChunk(int chunkPosition, List<ImageHeapObject> objects) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.rememberedSet.enableRememberedSetForAlignedChunk(new HostedByteBufferPointer(this.buffer, chunkOffset), chunkPosition, objects);
    }

    @Override
    public void enableRememberedSetForUnalignedChunk(int chunkPosition) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.rememberedSet.enableRememberedSetForUnalignedChunk(new HostedByteBufferPointer(this.buffer, chunkOffset));
    }

    static void putObjectReference(ByteBuffer buffer, int offset, long value) {
        switch (ConfigurationValues.getObjectLayout().getReferenceSize()) {
            case 4: {
                buffer.putInt(offset, NumUtil.safeToInt((long)value));
                break;
            }
            case 8: {
                buffer.putLong(offset, value);
                break;
            }
            default: {
                VMError.shouldNotReachHere("Unsupported reference size");
            }
        }
    }
}

