/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.FrameState;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.WordFactory;

public class FrameInfoQueryResult
extends FrameSourceInfo {
    protected FrameInfoQueryResult caller;
    protected SharedMethod deoptMethod;
    protected CodeInfo deoptMethodImageCodeInfo;
    protected int deoptMethodOffset;
    protected boolean isDeoptEntry;
    protected int numLocals;
    protected int numStack;
    protected int numLocks;
    protected ValueInfo[] valueInfos;
    protected ValueInfo[][] virtualObjects;
    protected int sourceMethodId;
    private ResolvedJavaMethod sourceMethod;
    private int sourceMethodModifiers;
    private String sourceMethodSignature;

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void init() {
        super.init();
        this.caller = null;
        this.deoptMethod = null;
        this.deoptMethodOffset = 0;
        this.deoptMethodImageCodeInfo = SubstrateUtil.HOSTED ? null : (CodeInfo)WordFactory.nullPointer();
        this.isDeoptEntry = false;
        this.numLocals = 0;
        this.numStack = 0;
        this.numLocks = 0;
        this.valueInfos = null;
        this.virtualObjects = null;
        this.sourceMethodId = 0;
        this.sourceMethod = null;
        this.sourceMethodSignature = CodeInfoEncoder.Encoders.INVALID_METHOD_SIGNATURE;
        this.sourceMethodModifiers = -1;
    }

    public FrameInfoQueryResult getCaller() {
        return this.caller;
    }

    public SharedMethod getDeoptMethod() {
        return this.deoptMethod;
    }

    public int getDeoptMethodOffset() {
        return this.deoptMethodOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isDeoptMethodImageCodeInfoNull() {
        if (SubstrateUtil.HOSTED) {
            return this.deoptMethodImageCodeInfo == null;
        }
        return this.deoptMethodImageCodeInfo.isNull();
    }

    public CodeInfo getDeoptMethodImageCodeInfo() {
        if (this.isDeoptMethodImageCodeInfoNull() && this.deoptMethod != null) {
            this.deoptMethodImageCodeInfo = CodeInfoTable.getImageCodeInfo(this.deoptMethod);
            assert (!this.isDeoptMethodImageCodeInfoNull());
        }
        return this.deoptMethodImageCodeInfo;
    }

    public CodePointer getDeoptMethodAddress() {
        if (this.deoptMethodOffset == 0) {
            return (CodePointer)WordFactory.nullPointer();
        }
        return CodeInfoAccess.absoluteIP(this.getDeoptMethodImageCodeInfo(), this.deoptMethodOffset);
    }

    public long getEncodedBci() {
        return this.encodedBci;
    }

    public FrameState.StackState getStackState() {
        return FrameState.StackState.of((boolean)FrameInfoDecoder.decodeDuringCall(this.encodedBci), (boolean)FrameInfoDecoder.decodeRethrowException(this.encodedBci));
    }

    public boolean isDeoptEntry() {
        return this.isDeoptEntry;
    }

    public int getNumLocals() {
        return this.numLocals;
    }

    public int getNumLocks() {
        return this.numLocks;
    }

    public int getNumStack() {
        return this.numStack;
    }

    public boolean hasLocalValueInfo() {
        return this.valueInfos != null;
    }

    public ValueInfo[] getValueInfos() {
        return this.valueInfos;
    }

    public ValueInfo[][] getVirtualObjects() {
        return this.virtualObjects;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void fillSourceFieldsIfMissing() {
        if (this.sourceMethodId != 0 && this.sourceClass == CodeInfoEncoder.Encoders.INVALID_CLASS) {
            CodeInfoDecoder.fillSourceFields(this);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Identity comparison against sentinel string value")
    void setSourceFields(Class<?> clazz, String methodName, String signature, int modifiers) {
        assert (this.sourceClass == CodeInfoEncoder.Encoders.INVALID_CLASS && this.sourceMethodName == "" && this.sourceMethodSignature == CodeInfoEncoder.Encoders.INVALID_METHOD_SIGNATURE && this.sourceMethodModifiers == -1);
        this.sourceClass = clazz;
        this.sourceMethodName = methodName;
        this.sourceMethodSignature = signature;
        this.sourceMethodModifiers = modifiers;
    }

    ResolvedJavaMethod getSourceMethod() {
        return this.sourceMethod;
    }

    void setSourceMethod(ResolvedJavaMethod method) {
        assert (method != null);
        assert (this.sourceMethod == null) : this.sourceMethod;
        this.sourceMethod = method;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSourceMethodId() {
        return this.sourceMethodId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSourceMethodModifiers() {
        this.fillSourceFieldsIfMissing();
        return this.sourceMethodModifiers;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceMethodSignature() {
        this.fillSourceFieldsIfMissing();
        return this.sourceMethodSignature;
    }

    public Log log(Log log) {
        this.fillSourceFieldsIfMissing();
        String className = this.sourceClass != null ? this.sourceClass.getName() : "";
        String methodName = this.sourceMethodName != null ? this.sourceMethodName : "";
        log.string(className);
        if (!className.isEmpty() && !methodName.isEmpty()) {
            log.string(".");
        }
        log.string(methodName);
        if (this.isDeoptEntry()) {
            log.string("**");
        }
        log.string("(");
        if (this.isNativeMethod()) {
            log.string("Native Method");
        } else {
            String sourceFileName;
            String string = sourceFileName = this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
            if (sourceFileName != null) {
                if (this.sourceLineNumber >= 0) {
                    log.string(sourceFileName).string(":").signed(this.sourceLineNumber);
                } else {
                    log.string(sourceFileName);
                }
            } else {
                log.string("Unknown Source");
            }
        }
        log.string(")");
        return log;
    }

    public static class ValueInfo {
        protected ValueType type;
        protected JavaKind kind;
        protected boolean isCompressedReference;
        protected boolean isEliminatedMonitor;
        protected long data;
        protected JavaConstant value;

        public ValueType getType() {
            return this.type;
        }

        public JavaKind getKind() {
            return this.kind;
        }

        public boolean isCompressedReference() {
            return this.isCompressedReference;
        }

        public boolean isEliminatedMonitor() {
            return this.isEliminatedMonitor;
        }

        public long getData() {
            return this.data;
        }

        public JavaConstant getValue() {
            return this.value;
        }
    }

    public static enum ValueType {
        Illegal(false),
        StackSlot(true),
        Register(true),
        ReservedRegister(true),
        Constant(true),
        DefaultConstant(false),
        VirtualObject(true);

        final boolean hasData;

        private ValueType(boolean hasData) {
            this.hasData = hasData;
        }
    }
}

