/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public class IsolateListenerSupport {
    private IsolateListener[] listeners = new IsolateListener[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateListenerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(IsolateListener listener) {
        assert (listener != null);
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }

    @Fold
    public static IsolateListenerSupport singleton() {
        return (IsolateListenerSupport)ImageSingletons.lookup(IsolateListenerSupport.class);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public void afterCreateIsolate(Isolate isolate) {
        for (IsolateListener listener : this.listeners) {
            try {
                listener.afterCreateIsolate(isolate);
            }
            catch (Throwable e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void onIsolateTeardown() {
        for (int i = this.listeners.length - 1; i >= 0; --i) {
            try {
                this.listeners[i].onIsolateTeardown();
                continue;
            }
            catch (Throwable e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    public static interface IsolateListener {
        @Uninterruptible(reason="Thread state not yet set up.")
        default public void afterCreateIsolate(Isolate isolate) {
        }

        @Uninterruptible(reason="The isolate teardown is in progress.")
        default public void onIsolateTeardown() {
        }
    }
}

