/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionClassFilter;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.File;
import java.lang.module.ModuleFinder;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicSet;

public class OptionClassFilterBuilder {
    private final String javaIdentifier = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private final Pattern validOptionValue = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private final ImageClassLoader imageClassLoader;
    private final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> baseOption;
    private final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> pathsOption;
    private final Map<URI, Module> uriModuleMap;
    protected final Map<String, Set<OptionOrigin>> requireCompletePackageOrClass = new HashMap<String, Set<OptionOrigin>>();
    private final Set<Module> requireCompleteModules = new HashSet<Module>();
    private boolean requireCompleteAll;

    public static OptionClassFilter createFilter(ImageClassLoader imageClassLoader, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> baseOption, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> pathsOption) {
        OptionClassFilterBuilder builder = new OptionClassFilterBuilder(imageClassLoader, baseOption, pathsOption);
        baseOption.getValue().getValuesWithOrigins().forEach(o -> builder.extractBaseOptionValue((String)o.value(), o.origin()));
        pathsOption.getValue().getValuesWithOrigins().forEach(o -> builder.extractPathsOptionValue((String)o.value(), o.origin()));
        return builder.build();
    }

    public OptionClassFilterBuilder(ImageClassLoader imageClassLoader, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> baseOption, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> pathsOption) {
        this.imageClassLoader = imageClassLoader;
        this.baseOption = baseOption;
        this.pathsOption = pathsOption;
        this.uriModuleMap = ModuleFinder.of((Path[])imageClassLoader.applicationModulePath().toArray(Path[]::new)).findAll().stream().filter(mRef -> mRef.location().isPresent()).collect(Collectors.toUnmodifiableMap(mRef -> mRef.location().get(), mRef -> imageClassLoader.findModule(mRef.descriptor().name()).get()));
    }

    private void extractBaseOptionValue(String value, OptionOrigin origin) {
        URI container = origin.container();
        if (value.isEmpty()) {
            if (origin.commandLineLike()) {
                this.requireCompleteAll = true;
                return;
            }
            Module originModule = this.uriModuleMap.get(container);
            if (originModule != null) {
                this.requireCompleteModules.add(originModule);
                return;
            }
            throw UserError.abort("Using '%s' without args only allowed on module-path. %s not part of module-path.", SubstrateOptionsParser.commandArgument(this.baseOption, value), origin);
        }
        for (String entry : OptionUtils.resolveOptionValuesRedirection(this.baseOption, value, origin)) {
            if (this.validOptionValue.matcher(entry).matches()) {
                if (!(origin.commandLineLike() || this.imageClassLoader.classes(container).contains((Object)entry) || this.imageClassLoader.packages(container).contains((Object)entry))) {
                    throw UserError.abort("Option '%s' provided by %s contains '%s'. No such package or class name found in '%s'.", SubstrateOptionsParser.commandArgument(this.baseOption, value), origin, entry, container);
                }
                this.requireCompletePackageOrClass.computeIfAbsent(entry, unused -> new HashSet()).add(origin);
                continue;
            }
            throw UserError.abort("Entry '%s' in option '%s' provided by %s is neither a package nor a fully qualified classname.", entry, SubstrateOptionsParser.commandArgument(this.baseOption, value), origin);
        }
    }

    private void extractPathsOptionValue(String value, OptionOrigin origin) {
        if (!origin.commandLineLike()) {
            throw UserError.abort("Using '%s' is only allowed on command line.", SubstrateOptionsParser.commandArgument(this.pathsOption, value), origin);
        }
        if (value.isEmpty()) {
            throw UserError.abort("Using '%s' requires directory or jar-file path arguments.", SubstrateOptionsParser.commandArgument(this.pathsOption, value), origin);
        }
        for (String pathStr : SubstrateUtil.split(value, File.pathSeparator)) {
            Path path = Path.of(pathStr, new String[0]);
            EconomicSet<String> packages = this.imageClassLoader.packages(path.toAbsolutePath().normalize().toUri());
            if (this.imageClassLoader.noEntryForURI(packages)) {
                throw UserError.abort("Option '%s' provided by %s contains entry '%s'. No such entry exists on class or module-path.", SubstrateOptionsParser.commandArgument(this.pathsOption, value), origin, pathStr);
            }
            for (String pkg : packages) {
                this.requireCompletePackageOrClass.put(pkg, Collections.singleton(origin));
            }
        }
    }

    private OptionClassFilter build() {
        return new OptionClassFilter(this.requireCompletePackageOrClass, this.requireCompleteModules, this.requireCompleteAll);
    }
}

