/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jdk.JDKLatest;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreadHelper;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@TargetClass(className="java.lang.VirtualThread")
public final class Target_java_lang_VirtualThread {
    @Alias
    static int NEW;
    @Alias
    static int STARTED;
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    @Alias
    static int RUNNABLE;
    @Alias
    static int RUNNING;
    @Alias
    static int PARKING;
    @Alias
    static int PARKED;
    @Alias
    static int PINNED;
    @Alias
    static int YIELDING;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int YIELDED;
    @Alias
    static int TERMINATED;
    @Alias
    static int SUSPENDED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int TIMED_PARKING;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int TIMED_PARKED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int TIMED_PINNED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int UNPARKED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int BLOCKING;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int BLOCKED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int UNBLOCKED;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int WAITING;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int WAIT;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int TIMED_WAITING;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    static int TIMED_WAIT;
    @Alias
    static Target_jdk_internal_vm_ContinuationScope VTHREAD_SCOPE;
    @Alias
    @InjectAccessors(value=DefaultSchedulerAccessor.class)
    public static ForkJoinPool DEFAULT_SCHEDULER;
    @Alias
    @InjectAccessors(value=UnparkerAccessor.class)
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    private static ScheduledExecutorService UNPARKER;
    @Alias
    @InjectAccessors(value=DelayedTaskSchedulersAccessor.class)
    @TargetElement(onlyWith={JDKLatest.class})
    private static ScheduledExecutorService[] DELAYED_TASK_SCHEDULERS;
    @Alias
    @InjectAccessors(value=SchedulerAccessor.class)
    public Executor scheduler;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=NondefaultSchedulerSupplier.class)
    private Executor nondefaultScheduler;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    volatile int state;
    @TargetElement(onlyWith={JDKLatest.class})
    @Delete
    volatile Target_java_lang_VirtualThread next;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean blockPermit;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean onWaitingList;
    @TargetElement(onlyWith={JDKLatest.class})
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean notified;
    @Alias
    volatile Thread carrierThread;
    @Alias
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Alias
    volatile boolean interrupted;

    @Alias
    private static native ForkJoinPool createDefaultScheduler();

    @Alias
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    private static native ScheduledExecutorService createDelayedTaskScheduler();

    @Alias
    @TargetElement(onlyWith={JDKLatest.class})
    private static native ScheduledExecutorService[] createDelayedTaskSchedulers();

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    private void notifyJvmtiStart() {
    }

    @Substitute
    private void notifyJvmtiEnd() {
    }

    @Substitute
    private void notifyJvmtiMount(boolean hide) {
    }

    @Substitute
    private void notifyJvmtiUnmount(boolean hide) {
    }

    @Substitute
    @TargetElement(name="notifyJvmtiHideFrames", onlyWith={JDK21OrEarlier.class})
    private void notifyJvmtiHideFramesJDK22(boolean hide) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    private static void notifyJvmtiDisableSuspend(boolean enter) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    private static void postPinnedEvent(String op) {
    }

    @Alias
    public static native Target_jdk_internal_vm_ContinuationScope continuationScope();

    @Delete
    native StackTraceElement[] asyncGetStackTrace();

    @Alias
    native StackTraceElement[] tryGetStackTrace();

    @Substitute
    @TargetElement(name="getAndClearInterrupt", onlyWith={JDK21OrEarlier.class})
    boolean getAndClearInterruptJDK21() {
        assert (Thread.currentThread() == SubstrateUtil.cast(this, Object.class));
        boolean oldValue = this.interrupted;
        if (oldValue) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                this.interrupted = false;
                VirtualThreadHelper.asTarget(this.carrierThread).clearInterrupt();
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        return oldValue;
    }

    @Alias
    @TargetElement(onlyWith={JDKLatest.class})
    native void disableSuspendAndPreempt();

    @Alias
    @TargetElement(onlyWith={JDKLatest.class})
    native void enableSuspendAndPreempt();

    @Alias
    @TargetElement(onlyWith={JDKLatest.class})
    native Object carrierThreadAccessLock();

    @Alias
    private native void setCarrierThread(Target_java_lang_Thread var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    void mount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(Target_java_lang_Thread.currentCarrierThread());
        this.setCarrierThread(carrier);
        if (this.interrupted) {
            carrier.setInterrupt();
        } else if (carrier.isInterrupted()) {
            Object object = VirtualThreadHelper.asTarget((Object)this).interruptLock;
            synchronized (object) {
                if (!this.interrupted) {
                    carrier.clearInterrupt();
                }
            }
        }
        carrier.setCurrentThread(VirtualThreadHelper.asThread(this));
        if (HasJfrSupport.get()) {
            SubstrateJVM.getThreadRepo().registerThread(VirtualThreadHelper.asThread(this));
        }
    }

    @Substitute
    @TargetElement(name="unmount", onlyWith={JDK21OrEarlier.class})
    void unmountJDK21() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(this.carrierThread);
        carrier.setCurrentThread(VirtualThreadHelper.asThread(carrier));
        Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
        try {
            this.setCarrierThread(null);
        }
        finally {
            VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
        }
        carrier.clearInterrupt();
    }

    @Alias
    native int state();

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    void setState(int s) {
        assert (s != BLOCKING && s != BLOCKED && s != UNBLOCKED && s != WAITING && s != WAIT && s != TIMED_WAIT && s != TIMED_WAITING) : "states should never be reached with our monitor implementation";
        this.state = s;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    void waitTimeoutExpired(byte seqNo) {
        throw VMError.shouldNotReachHere("not used in our monitor implementation");
    }

    @Delete
    @TargetElement(onlyWith={JDKLatest.class})
    static native void unblockVirtualThreads();

    @Delete
    @TargetElement(onlyWith={JDKLatest.class})
    private static native Target_java_lang_VirtualThread takeVirtualThreadListToUnblock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    Thread.State threadState() {
        int state = this.state() & ~SUSPENDED;
        if (state == NEW) {
            return Thread.State.NEW;
        }
        if (state == STARTED) {
            if (VirtualThreadHelper.asTarget(this).threadContainer() == null) {
                return Thread.State.NEW;
            }
            return Thread.State.RUNNABLE;
        }
        if (state == UNPARKED || state == YIELDED) {
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNING) {
            if (Thread.currentThread() != VirtualThreadHelper.asThread(this)) {
                this.disableSuspendAndPreempt();
                try {
                    Object object = this.carrierThreadAccessLock();
                    synchronized (object) {
                        block23: {
                            Thread carrier = this.carrierThread;
                            if (carrier == null) break block23;
                            Thread.State state2 = VirtualThreadHelper.asTarget(carrier).threadState();
                            return state2;
                        }
                    }
                }
                finally {
                    this.enableSuspendAndPreempt();
                }
            }
            return Thread.State.RUNNABLE;
        }
        if (state == PARKING || state == YIELDING) {
            return Thread.State.RUNNABLE;
        }
        if (state == PARKED || state == PINNED || state == TIMED_PARKED || state == TIMED_PINNED) {
            boolean timed = state == TIMED_PARKED || state == TIMED_PINNED;
            int parkedThreadStatus = MonitorSupport.singleton().getParkedThreadStatus(VirtualThreadHelper.asThread(this), timed);
            switch (parkedThreadStatus) {
                case 1025: {
                    return Thread.State.BLOCKED;
                }
                case 401: 
                case 657: {
                    return Thread.State.WAITING;
                }
                case 417: 
                case 673: {
                    return Thread.State.TIMED_WAITING;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parkedThreadStatus);
        }
        if (state == TERMINATED) {
            return Thread.State.TERMINATED;
        }
        if (state == TIMED_PARKING) {
            return Thread.State.RUNNABLE;
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(name="threadState", onlyWith={JDK21OrEarlier.class})
    Thread.State threadStateJDK21() {
        int state = this.state() & ~SUSPENDED;
        if (state == NEW) {
            return Thread.State.NEW;
        }
        if (state == STARTED) {
            if (VirtualThreadHelper.asTarget(this).threadContainer() == null) {
                return Thread.State.NEW;
            }
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNABLE) {
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNING) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                Thread carrier = this.carrierThread;
                if (carrier != null) {
                    Thread.State state2 = VirtualThreadHelper.asTarget(carrier).threadState();
                    return state2;
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
            return Thread.State.RUNNABLE;
        }
        if (state == PARKING || state == YIELDING) {
            return Thread.State.RUNNABLE;
        }
        if (state == PARKED || state == PINNED) {
            int parkedThreadStatus = MonitorSupport.singleton().getParkedThreadStatus(VirtualThreadHelper.asThread(this), false);
            switch (parkedThreadStatus) {
                case 1025: {
                    return Thread.State.BLOCKED;
                }
                case 401: 
                case 657: {
                    return Thread.State.WAITING;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parkedThreadStatus);
        }
        if (state == TERMINATED) {
            return Thread.State.TERMINATED;
        }
        throw new InternalError();
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native boolean isTerminated();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(name="toString", onlyWith={JDK21OrEarlier.class})
    public String toStringJDK21() {
        StringBuilder sb = new StringBuilder("VirtualThread[#");
        sb.append(VirtualThreadHelper.asTarget(this).threadId());
        String name = VirtualThreadHelper.asThread(this).getName();
        if (!name.isEmpty()) {
            sb.append(",");
            sb.append(name);
        }
        sb.append("]/");
        Thread carrier = this.carrierThread;
        if (carrier != null) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                carrier = this.carrierThread;
                if (carrier != null) {
                    String stateAsString = VirtualThreadHelper.asTarget(carrier).threadState().toString();
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                    sb.append('@');
                    sb.append(carrier.getName());
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        if (carrier == null) {
            String stateAsString = this.threadStateJDK21().toString();
            sb.append(stateAsString.toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    @Alias
    native void interrupt();

    @Alias
    native void unpark();

    private static final class NondefaultSchedulerSupplier
    implements FieldValueTransformer {
        private NondefaultSchedulerSupplier() {
        }

        public Object transform(Object receiver, Object originalValue) {
            Class vthreadClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.VirtualThread");
            Object defaultScheduler = ReflectionUtil.readStaticField((Class)vthreadClass, (String)"DEFAULT_SCHEDULER");
            return originalValue == defaultScheduler ? null : originalValue;
        }
    }

    private static final class SchedulerAccessor {
        private SchedulerAccessor() {
        }

        static Executor get(Target_java_lang_VirtualThread self) {
            Executor scheduler = self.nondefaultScheduler;
            if (scheduler == null) {
                scheduler = DefaultSchedulerAccessor.get();
            }
            return scheduler;
        }

        static void set(Target_java_lang_VirtualThread self, Executor executor) {
            assert (self.nondefaultScheduler == null);
            if (executor != DefaultSchedulerAccessor.get()) {
                self.nondefaultScheduler = executor;
            }
        }
    }

    private static final class DelayedTaskSchedulersAccessor {
        private static volatile ScheduledExecutorService[] delayedTaskSchedulers;

        private DelayedTaskSchedulersAccessor() {
        }

        public static ScheduledExecutorService[] get() {
            ScheduledExecutorService[] result = delayedTaskSchedulers;
            if (result == null) {
                result = DelayedTaskSchedulersAccessor.initializeDelayedTaskScheduler();
            }
            return result;
        }

        private static synchronized ScheduledExecutorService[] initializeDelayedTaskScheduler() {
            ScheduledExecutorService[] result = delayedTaskSchedulers;
            if (result == null) {
                result = Target_java_lang_VirtualThread.createDelayedTaskSchedulers();
                delayedTaskSchedulers = result;
            }
            return result;
        }
    }

    private static final class UnparkerAccessor {
        private static volatile ScheduledExecutorService delayedTaskScheduler;

        private UnparkerAccessor() {
        }

        public static ScheduledExecutorService get() {
            ScheduledExecutorService result = delayedTaskScheduler;
            if (result == null) {
                result = UnparkerAccessor.initializeDelayedTaskScheduler();
            }
            return result;
        }

        private static synchronized ScheduledExecutorService initializeDelayedTaskScheduler() {
            ScheduledExecutorService result = delayedTaskScheduler;
            if (result == null) {
                delayedTaskScheduler = result = Target_java_lang_VirtualThread.createDelayedTaskScheduler();
            }
            return result;
        }
    }

    private static final class DefaultSchedulerAccessor {
        private static volatile ForkJoinPool defaultScheduler;

        private DefaultSchedulerAccessor() {
        }

        public static ForkJoinPool get() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                result = DefaultSchedulerAccessor.initializeDefaultScheduler();
            }
            return result;
        }

        private static synchronized ForkJoinPool initializeDefaultScheduler() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                defaultScheduler = result = Target_java_lang_VirtualThread.createDefaultScheduler();
            }
            return result;
        }
    }

    private static final class AlwaysFalseAccessor {
        private AlwaysFalseAccessor() {
        }

        static boolean get(Target_java_lang_VirtualThread vt) {
            return false;
        }

        static void set(Target_java_lang_VirtualThread vt, boolean value) {
            assert (!value);
        }
    }
}

