/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class ChunkBasedCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    private static final OutOfMemoryError ALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an aligned heap chunk. Either the OS/container is out of memory or another system-level resource limit was reached (such as the number of memory mappings).");
    private static final OutOfMemoryError UNALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an unaligned heap chunk. Either the OS/container is out of memory or another system-level resource limit was reached (such as the number of memory mappings).");

    @Fold
    public static ChunkBasedCommittedMemoryProvider get() {
        return (ChunkBasedCommittedMemoryProvider)ImageSingletons.lookup(CommittedMemoryProvider.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord nbytes, UnsignedWord alignment) {
        Pointer result = this.allocate(nbytes, alignment, false, NmtCategory.JavaHeap);
        if (result.isNull()) {
            throw ALIGNED_OUT_OF_MEMORY_ERROR;
        }
        return result;
    }

    public Pointer allocateUnalignedChunk(UnsignedWord nbytes) {
        Pointer result = this.allocate(nbytes, ChunkBasedCommittedMemoryProvider.getAlignmentForUnalignedChunks(), false, NmtCategory.JavaHeap);
        if (result.isNull()) {
            throw UNALIGNED_OUT_OF_MEMORY_ERROR;
        }
        return result;
    }

    public boolean areUnalignedChunksZeroed() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        ChunkBasedCommittedMemoryProvider.free(start, nbytes, NmtCategory.JavaHeap);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase start, UnsignedWord nbytes) {
        ChunkBasedCommittedMemoryProvider.free(start, nbytes, NmtCategory.JavaHeap);
    }

    @Fold
    protected static UnsignedWord getAlignmentForUnalignedChunks() {
        int alignment = Math.max(ConfigurationValues.getTarget().wordSize, ConfigurationValues.getObjectLayout().getAlignment());
        return WordFactory.unsigned((int)alignment);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void afterGarbageCollection() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
    }
}

