/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.nio.ByteOrder;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class BufferedFileOperationSupport {
    private static final int BUFFER_SIZE = 4096;
    private static final int LARGE_DATA_THRESHOLD = 1024;
    private final boolean useNativeByteOrder;

    @Fold
    public static BufferedFileOperationSupport littleEndian() {
        return BufferedFileOperationSupportHolder.singleton().littleEndian;
    }

    @Fold
    public static BufferedFileOperationSupport bigEndian() {
        return BufferedFileOperationSupportHolder.singleton().bigEndian;
    }

    @Fold
    public static BufferedFileOperationSupport nativeByteOrder() {
        return BufferedFileOperationSupportHolder.singleton().nativeOrder;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected BufferedFileOperationSupport(boolean useNativeByteOrder) {
        this.useNativeByteOrder = useNativeByteOrder;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public BufferedFile allocate(RawFileOperationSupport.RawFileDescriptor fd, NmtCategory nmtCategory) {
        if (!BufferedFileOperationSupport.rawFiles().isValid(fd)) {
            return (BufferedFile)WordFactory.nullPointer();
        }
        long filePosition = BufferedFileOperationSupport.rawFiles().position(fd);
        if (filePosition < 0L) {
            return (BufferedFile)WordFactory.nullPointer();
        }
        UnsignedWord totalSize = SizeOf.unsigned(BufferedFile.class).add(WordFactory.unsigned((int)4096));
        BufferedFile result = (BufferedFile)NullableNativeMemory.malloc(totalSize, nmtCategory);
        if (result.isNull()) {
            return (BufferedFile)WordFactory.nullPointer();
        }
        result.setFileDescriptor(fd);
        result.setFilePosition(filePosition);
        result.setBufferPos(BufferedFileOperationSupport.getBufferStart(result));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(BufferedFile f) {
        NullableNativeMemory.free(f);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean flush(BufferedFile f) {
        int unflushed = this.getUnflushedDataSize(f);
        if (unflushed == 0) {
            return true;
        }
        boolean success = BufferedFileOperationSupport.rawFiles().write(f.getFileDescriptor(), BufferedFileOperationSupport.getBufferStart(f), WordFactory.unsigned((int)unflushed));
        if (success) {
            f.setBufferPos(BufferedFileOperationSupport.getBufferStart(f));
            f.setFilePosition(f.getFilePosition() + (long)unflushed);
            assert (f.getFilePosition() == BufferedFileOperationSupport.rawFiles().position(f.getFileDescriptor()));
        }
        return success;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long position(BufferedFile f) {
        return f.getFilePosition() + (long)this.getUnflushedDataSize(f);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean seek(BufferedFile f, long position) {
        if (position >= 0L && this.flush(f) && BufferedFileOperationSupport.rawFiles().seek(f.getFileDescriptor(), position)) {
            f.setFilePosition(position);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean write(BufferedFile f, Pointer data, UnsignedWord size) {
        if (size.aboveOrEqual(1024)) {
            if (this.flush(f) && BufferedFileOperationSupport.rawFiles().write(f.getFileDescriptor(), data, size)) {
                f.setFilePosition(f.getFilePosition() + size.rawValue());
                assert (f.getFilePosition() == BufferedFileOperationSupport.rawFiles().position(f.getFileDescriptor()));
                assert (f.getBufferPos() == BufferedFileOperationSupport.getBufferStart(f));
                return true;
            }
            return false;
        }
        assert ((long)((int)size.rawValue()) == size.rawValue());
        if (!this.ensureBufferSpace(f, (int)size.rawValue())) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        UnmanagedMemoryUtil.copy(data, pos, size);
        f.setBufferPos(pos.add(size));
        return true;
    }

    @Uninterruptible(reason="Array must not move.")
    public boolean write(BufferedFile f, byte[] data) {
        DynamicHub hub = KnownIntrinsics.readHub(data);
        UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
        Word dataPtr = Word.objectToUntrackedPointer((Object)data).add(baseOffset);
        return this.write(f, (Pointer)dataPtr, WordFactory.unsigned((int)data.length));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeBoolean(BufferedFile f, boolean data) {
        return this.writeByte(f, (byte)(data ? 1 : 0));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeByte(BufferedFile f, byte data) {
        if (!this.ensureBufferSpace(f, 1)) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        pos.writeByte(0, data);
        f.setBufferPos(pos.add(1));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeShort(BufferedFile f, short data) {
        if (!this.ensureBufferSpace(f, 2)) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        pos.writeShort(0, this.useNativeByteOrder ? data : Short.reverseBytes(data));
        f.setBufferPos(pos.add(2));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeChar(BufferedFile f, char data) {
        if (!this.ensureBufferSpace(f, 2)) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        pos.writeChar(0, this.useNativeByteOrder ? data : Character.reverseBytes(data));
        f.setBufferPos(pos.add(2));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeInt(BufferedFile f, int data) {
        if (!this.ensureBufferSpace(f, 4)) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        pos.writeInt(0, this.useNativeByteOrder ? data : Integer.reverseBytes(data));
        f.setBufferPos(pos.add(4));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeLong(BufferedFile f, long v) {
        if (!this.ensureBufferSpace(f, 8)) {
            return false;
        }
        Pointer pos = f.getBufferPos();
        pos.writeLong(0, this.useNativeByteOrder ? v : Long.reverseBytes(v));
        f.setBufferPos(pos.add(8));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeFloat(BufferedFile f, float v) {
        return this.writeInt(f, Float.floatToIntBits(v));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeDouble(BufferedFile f, double v) {
        return this.writeLong(f, Double.doubleToLongBits(v));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeUTF8(BufferedFile f, String string) {
        boolean success = true;
        for (int index = 0; index < string.length() && success; success &= this.writeUTF8(f, UninterruptibleUtils.String.charAt(string, index)), ++index) {
        }
        return success;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean writeUTF8(BufferedFile f, char c) {
        boolean success;
        if (c <= '\u007f') {
            success = this.writeByte(f, (byte)c);
        } else if (c <= '\u07ff') {
            success = this.writeByte(f, (byte)(0xC0 | c >> 6));
            success = success && this.writeByte(f, (byte)(0x80 | c & 0x3F));
        } else {
            success = this.writeByte(f, (byte)(0xE0 | c >> 12));
            success = success && this.writeByte(f, (byte)(0x80 | c >> 6 & 0x3F));
            success = success && this.writeByte(f, (byte)(0x80 | c & 0x3F));
        }
        return success;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getUnflushedDataSize(BufferedFile f) {
        Pointer result = f.getBufferPos().subtract((UnsignedWord)BufferedFileOperationSupport.getBufferStart(f));
        assert (result.belowOrEqual(4096));
        return (int)result.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getBufferStart(BufferedFile f) {
        return ((Pointer)f).add(SizeOf.unsigned(BufferedFile.class));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean ensureBufferSpace(BufferedFile f, int size) {
        assert (size <= 4096) : "only called for small data";
        if (this.getUnflushedDataSize(f) + size >= 4096) {
            return this.flush(f);
        }
        return true;
    }

    @Fold
    static RawFileOperationSupport rawFiles() {
        return RawFileOperationSupport.nativeByteOrder();
    }

    public static class BufferedFileOperationSupportHolder {
        private final BufferedFileOperationSupport littleEndian;
        private final BufferedFileOperationSupport bigEndian;
        private final BufferedFileOperationSupport nativeOrder;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public BufferedFileOperationSupportHolder() {
            ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
            assert (nativeByteOrder == ByteOrder.LITTLE_ENDIAN || nativeByteOrder == ByteOrder.BIG_ENDIAN);
            this.littleEndian = new BufferedFileOperationSupport(ByteOrder.LITTLE_ENDIAN == nativeByteOrder);
            this.bigEndian = new BufferedFileOperationSupport(ByteOrder.BIG_ENDIAN == nativeByteOrder);
            this.nativeOrder = nativeByteOrder == ByteOrder.LITTLE_ENDIAN ? this.littleEndian : this.bigEndian;
        }

        @Fold
        static BufferedFileOperationSupportHolder singleton() {
            return (BufferedFileOperationSupportHolder)ImageSingletons.lookup(BufferedFileOperationSupportHolder.class);
        }
    }

    @RawStructure
    public static interface BufferedFile
    extends PointerBase {
        @RawField
        public RawFileOperationSupport.RawFileDescriptor getFileDescriptor();

        @RawField
        public void setFileDescriptor(RawFileOperationSupport.RawFileDescriptor var1);

        @RawField
        public Pointer getBufferPos();

        @RawField
        public void setBufferPos(Pointer var1);

        @RawField
        public long getFilePosition();

        @RawField
        public void setFilePosition(long var1);
    }
}

