/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.Target_java_lang_Throwable;
import com.oracle.svm.core.util.VMError;

public final class JDKUtils {
    public static String getRawMessage(Throwable ex) {
        return SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable.class).detailMessage;
    }

    public static Throwable getRawCause(Throwable ex) {
        Throwable cause = SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable.class).cause;
        return cause == ex ? null : cause;
    }

    public static StackTraceElement[] getRawStackTrace(Throwable ex) {
        VMError.guarantee(JDKUtils.isStackTraceValid(ex));
        return SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable.class).stackTrace;
    }

    public static boolean isStackTraceValid(Throwable ex) {
        StackTraceElement[] stackTrace = SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable.class).stackTrace;
        return stackTrace != Target_java_lang_Throwable.UNASSIGNED_STACK && stackTrace != null;
    }

    public static Object getBacktrace(Throwable ex) {
        VMError.guarantee(!JDKUtils.isStackTraceValid(ex));
        return SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable.class).backtrace;
    }
}

