/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

final class ReciprocalLeastSquareFit {
    private final double discount;
    private double sumY;
    private double sumXReciprocal;
    private double sumYdivX;
    private double sumXSquareReciprocal;
    private double count;
    private double a;
    private double b;

    ReciprocalLeastSquareFit(double effectiveHistoryLength) {
        assert (effectiveHistoryLength > 0.0);
        this.discount = (effectiveHistoryLength - 1.0) / effectiveHistoryLength;
    }

    public void sample(double x, double y) {
        assert (x != 0.0) : "division by zero";
        this.sumY = y + this.discount * this.sumY;
        this.sumXReciprocal = 1.0 / x + this.discount * this.sumXReciprocal;
        this.sumYdivX = y / x + this.discount * this.sumYdivX;
        this.sumXSquareReciprocal = 1.0 / (x * x) + this.discount * this.sumXSquareReciprocal;
        this.count = 1.0 + this.discount * this.count;
        double denominator = this.count * this.sumXSquareReciprocal - this.sumXReciprocal * this.sumXReciprocal;
        if (denominator != 0.0) {
            this.b = (this.count * this.sumYdivX - this.sumXReciprocal * this.sumY) / denominator;
            this.a = (this.sumY - this.b * this.sumXReciprocal) / this.count;
        }
    }

    public double estimate(double x) {
        return this.a + this.b / x;
    }

    public double getSlope(double x) {
        return -this.b / (x * x);
    }
}

