/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public record ConstantValueFieldValueTransformer(Object value) implements FieldValueTransformer
{
    public static FieldValueTransformer defaultValueForField(ResolvedJavaField field) {
        return new ConstantValueFieldValueTransformer(switch (field.getType().getJavaKind()) {
            case JavaKind.Byte -> (byte)0;
            case JavaKind.Boolean -> Boolean.valueOf(false);
            case JavaKind.Short -> (short)0;
            case JavaKind.Char -> Character.valueOf('\u0000');
            case JavaKind.Int -> 0;
            case JavaKind.Long -> 0L;
            case JavaKind.Float -> Float.valueOf(0.0f);
            case JavaKind.Double -> 0.0;
            case JavaKind.Object -> null;
            default -> throw VMError.shouldNotReachHere(String.valueOf(field));
        });
    }

    public Object transform(Object receiver, Object originalValue) {
        return this.value;
    }
}

