/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerSubstitutionType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaType;

public class InjectedInvokerRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    public static final String INJECTED_INVOKER_CLASS_NAME_SUBSTRING = "$$InjectedInvoker";
    private final ConcurrentMap<ResolvedJavaType, InjectedInvokerSubstitutionType> typeSubstitutions = new ConcurrentHashMap<ResolvedJavaType, InjectedInvokerSubstitutionType>();

    public static boolean isInjectedInvokerType(ResolvedJavaType type) {
        String name = type.getName();
        return name.contains(INJECTED_INVOKER_CLASS_NAME_SUBSTRING);
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (!InjectedInvokerRenamingSubstitutionProcessor.shouldReplace(type)) {
            return type;
        }
        return this.getSubstitution(type);
    }

    private static boolean shouldReplace(ResolvedJavaType type) {
        return !(type instanceof InjectedInvokerSubstitutionType) && !(type instanceof BaseLayerType) && InjectedInvokerRenamingSubstitutionProcessor.isInjectedInvokerType(type);
    }

    private InjectedInvokerSubstitutionType getSubstitution(ResolvedJavaType original) {
        return this.typeSubstitutions.computeIfAbsent(original, key -> new InjectedInvokerSubstitutionType((ResolvedJavaType)key, InjectedInvokerRenamingSubstitutionProcessor.getUniqueInjectedInvokerName(key.getName())));
    }

    public static String getUniqueInjectedInvokerName(String className) {
        return className.substring(0, className.lastIndexOf(INJECTED_INVOKER_CLASS_NAME_SUBSTRING) + INJECTED_INVOKER_CLASS_NAME_SUBSTRING.length()) + ";";
    }
}

