/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ForeignIsolateReferenceAdjusterData;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedMirroredObject;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class IsolatedReferenceAdjuster
implements ReferenceAdjuster {
    private NonmovableArray<Pointer> addresses;
    private NonmovableArray<ObjectHandle> handles;
    private int count;

    IsolatedReferenceAdjuster() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setConstantTargetInArray(NonmovableObjectArray<T> array, int index, JavaConstant constant) {
        if (constant instanceof IsolatedObjectConstant) {
            this.record((PointerBase)NonmovableArrays.addressOf(array, index), ConfigurationValues.getObjectLayout().getReferenceSize(), ((IsolatedObjectConstant)constant).getHandle());
        } else {
            Object target = ((DirectSubstrateObjectConstant)constant).getObject();
            this.setObjectInArray(array, index, target);
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setObjectInArray(NonmovableObjectArray<T> array, int index, T object) {
        if (object instanceof IsolatedMirroredObject) {
            ClientHandle mirror = ((IsolatedMirroredObject)object).getMirror();
            assert (!mirror.equal((ComparableWord)IsolatedHandles.nullHandle())) : "Mirror object must not be null";
            this.record((PointerBase)NonmovableArrays.addressOf(array, index), ConfigurationValues.getObjectLayout().getReferenceSize(), mirror);
        } else {
            VMError.guarantee(ImageHeapObjects.isInImageHeap(object));
            NonmovableArrays.setObject(array, index, object);
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setConstantTargetAt(PointerBase address, int length, JavaConstant constant) {
        if (constant instanceof IsolatedObjectConstant) {
            this.record(address, length, ((IsolatedObjectConstant)constant).getHandle());
        } else {
            Object target = ((DirectSubstrateObjectConstant)constant).getObject();
            if (target instanceof IsolatedMirroredObject) {
                ClientHandle mirror = ((IsolatedMirroredObject)target).getMirror();
                assert (!mirror.equal((ComparableWord)IsolatedHandles.nullHandle())) : "Mirror object must not be null";
                this.record(address, ConfigurationValues.getObjectLayout().getReferenceSize(), mirror);
            } else {
                VMError.guarantee(ImageHeapObjects.isInImageHeap(target));
                ReferenceAdjuster.writeReference((Pointer)address, length, target);
            }
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> NonmovableObjectArray<T> copyOfObjectArray(T[] source, NmtCategory nmtCategory) {
        NonmovableObjectArray copy = NonmovableArrays.createObjectArray(source.getClass(), source.length, nmtCategory);
        for (int i = 0; i < source.length; ++i) {
            this.setObjectInArray(copy, i, source[i]);
        }
        return copy;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isFinished() {
        return this.addresses.isNull();
    }

    public ForeignIsolateReferenceAdjusterData exportData() {
        ForeignIsolateReferenceAdjusterData data = (ForeignIsolateReferenceAdjusterData)NativeMemory.malloc(SizeOf.get(ForeignIsolateReferenceAdjusterData.class), NmtCategory.Compiler);
        data.setCount(this.count);
        data.setAddresses(this.addresses);
        data.setHandles(this.handles);
        this.addresses = (NonmovableArray)WordFactory.nullPointer();
        this.handles = (NonmovableArray)WordFactory.nullPointer();
        this.count = 0;
        return data;
    }

    public static <T extends ObjectHandle> void adjustAndDispose(ForeignIsolateReferenceAdjusterData data, ThreadLocalHandles<T> handleSet) {
        int count = data.getCount();
        for (int i = 0; i < count; ++i) {
            ObjectHandle handle = NonmovableArrays.getWord(data.getHandles(), i);
            Object targetObject = handleSet.getObject(handle);
            Pointer address = NonmovableArrays.getWord(data.getAddresses(), i);
            ReferenceAdjuster.writeReference(address, ConfigurationValues.getObjectLayout().getReferenceSize(), targetObject);
        }
        NonmovableArrays.releaseUnmanagedArray(data.getAddresses());
        NonmovableArrays.releaseUnmanagedArray(data.getHandles());
        NativeMemory.free(data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void record(PointerBase address, int length, ObjectHandle handle) {
        this.growIfFull();
        NonmovableArrays.setWord(this.addresses, this.count, (Pointer)address);
        NonmovableArrays.setWord(this.handles, this.count, handle);
        ++this.count;
        ReferenceAdjuster.writeReference((Pointer)address, length, null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void growIfFull() {
        int oldSize;
        int n = oldSize = this.addresses.isNonNull() ? NonmovableArrays.lengthOf(this.addresses) : 0;
        if (this.count == oldSize) {
            int newSize = oldSize != 0 ? 2 * oldSize : 32;
            NonmovableArray newAddresses = NonmovableArrays.createWordArray(newSize, NmtCategory.Compiler);
            NonmovableArray newHandles = NonmovableArrays.createWordArray(newSize, NmtCategory.Compiler);
            if (this.addresses.isNonNull()) {
                NonmovableArrays.arraycopy(this.addresses, 0, newAddresses, 0, oldSize);
                NonmovableArrays.releaseUnmanagedArray(this.addresses);
                NonmovableArrays.arraycopy(this.handles, 0, newHandles, 0, oldSize);
                NonmovableArrays.releaseUnmanagedArray(this.handles);
            }
            this.addresses = newAddresses;
            this.handles = newHandles;
        }
    }
}

