/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import com.oracle.svm.util.ClassUtil;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.api.runtime.GraalRuntime;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.runtime.RuntimeProvider;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.stack.StackIntrospection;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateGraalRuntime
implements GraalRuntime,
RuntimeProvider {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateGraalRuntime() {
    }

    public String getName() {
        return ClassUtil.getUnqualifiedName(this.getClass());
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == RuntimeProvider.class) {
            return (T)this;
        }
        if (clazz == SnippetReflectionProvider.class) {
            RuntimeConfiguration runtimeConfiguration = TruffleRuntimeCompilationSupport.getRuntimeConfig();
            return (T)runtimeConfiguration.getProviders().getSnippetReflection();
        }
        if (clazz == StackIntrospection.class) {
            return (T)SubstrateStackIntrospection.SINGLETON;
        }
        return null;
    }

    public Backend getHostBackend() {
        return TruffleRuntimeCompilationSupport.getRuntimeConfig().getBackendForNormalMethod();
    }

    public <T extends Architecture> Backend getBackend(Class<T> arch) {
        assert (arch.isInstance(TruffleRuntimeCompilationSupport.getRuntimeConfig().getBackendForNormalMethod().getTarget().arch));
        return TruffleRuntimeCompilationSupport.getRuntimeConfig().getBackendForNormalMethod();
    }

    public String getCompilerConfigurationName() {
        return GraalConfiguration.runtimeInstance().getCompilerConfigurationName();
    }
}

