/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.PlatformTimeUtils;
import org.graalvm.nativeimage.StackValue;

@AutomaticallyRegisteredImageSingleton(value={PlatformTimeUtils.class})
public final class PosixPlatformTimeUtils
extends PlatformTimeUtils {
    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/os/posix/os_posix.cpp#L1409-L1415")
    @Uninterruptible(reason="Must not migrate platform threads when executing on a virtual thread.")
    public PlatformTimeUtils.SecondsNanos javaTimeSystemUTC() {
        Time.timespec ts = (Time.timespec)StackValue.get(Time.timespec.class);
        int status = PosixUtils.clock_gettime(Time.CLOCK_REALTIME(), ts);
        PosixUtils.checkStatusIs0(status, "javaTimeSystemUTC: clock_gettime(CLOCK_REALTIME) failed.");
        return PosixPlatformTimeUtils.allocateSecondsNanos0(ts.tv_sec(), ts.tv_nsec());
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly allocate a SecondsNanos object.", calleeMustBe=false)
    private static PlatformTimeUtils.SecondsNanos allocateSecondsNanos0(long seconds, long nanos) {
        return PosixPlatformTimeUtils.allocateSecondsNanos(seconds, nanos);
    }

    private static PlatformTimeUtils.SecondsNanos allocateSecondsNanos(long seconds, long nanos) {
        return new PlatformTimeUtils.SecondsNanos(seconds, nanos);
    }
}

