/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.jdk.localization.substitutions.modes.JvmLocaleMode;
import com.oracle.svm.core.jdk.localization.substitutions.modes.OptimizedLocaleMode;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.nativeimage.ImageSingletons;
import sun.util.resources.Bundles;

@TargetClass(value=Bundles.class)
final class Target_sun_util_resources_Bundles {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static ConcurrentMap<?, ?> cacheList = new ConcurrentHashMap();

    Target_sun_util_resources_Bundles() {
    }

    @TargetElement(name="loadBundleOf", onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle loadBundleOfOptimized(String baseName, Locale targetLocale, Bundles.Strategy strategy) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, targetLocale);
    }

    @TargetElement(onlyWith={JvmLocaleMode.class})
    @Alias
    private static native ResourceBundle loadBundleOf(String var0, Locale var1, Bundles.Strategy var2);

    @Substitute
    public static ResourceBundle of(String baseName, Locale locale, Bundles.Strategy strategy) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).jvmMode() ? Target_sun_util_resources_Bundles.loadBundleOf(baseName, locale, strategy) : Target_sun_util_resources_Bundles.loadBundleOfOptimized(baseName, locale, strategy);
    }
}

