/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;

public final class SubstrateDebugInfoBuilder
extends DebugInfoBuilder {
    private final SharedMethod method;

    public SubstrateDebugInfoBuilder(StructuredGraph graph, MetaAccessExtensionProvider metaAccessExtensionProvider, NodeValueMap nodeValueMap) {
        super(nodeValueMap, metaAccessExtensionProvider, graph.getDebug());
        this.method = (SharedMethod)graph.method();
    }

    protected JavaKind storageKind(JavaType type) {
        return ((SharedType)type).getStorageKind();
    }

    protected JavaValue computeLockValue(FrameState state, int lockIndex) {
        boolean eliminated;
        JavaValue object = this.toJavaValue(state.lockAt(lockIndex));
        boolean bl = eliminated = object instanceof VirtualObject || state.monitorIdAt(lockIndex).isEliminated();
        if (eliminated && this.method.isDeoptTarget()) {
            throw VMError.shouldNotReachHere("Deoptimization target method must not have virtual objects or eliminated locks: " + String.valueOf(this.method));
        }
        return new StackLockValue(object, Value.ILLEGAL, eliminated);
    }
}

