/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;

public final class SerialAndEpsilonGCOptions {
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(80), SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(10), SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(Long.valueOf(524288L), SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            int multiple = 4096;
            UserError.guarantee(newValue > 0L && newValue % (long)multiple == 0L, "%s value must be a multiple of %d.", this.getName(), multiple);
        }
    };
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(131072L, SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly);
    public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0, SerialAndEpsilonGCOptions::serialOrEpsilonGCOnly);

    private SerialAndEpsilonGCOptions() {
    }

    public static void serialOrEpsilonGCOnly(OptionKey<?> optionKey) {
        if (!SubstrateOptions.useSerialGC() && !SubstrateOptions.useEpsilonGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial') or the epsilon garbage collector ('--gc=epsilon').", new Object[0]);
        }
    }
}

