/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoVerifier;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.MethodTableFirstIDTracker;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.heap.CodeReferenceMapEncoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.util.FrequencyEncoder;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeWriter;
import jdk.graal.compiler.nodes.FrameState;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.ImageSingletons;

public class CodeInfoEncoder {
    private final TreeMap<Long, IPData> entries = new TreeMap();
    private final Encoders encoders;
    private final FrameInfoEncoder frameInfoEncoder;
    private NonmovableArray<Byte> codeInfoIndex;
    private NonmovableArray<Byte> codeInfoEncodings;
    private NonmovableArray<Byte> referenceMapEncoding;

    public CodeInfoEncoder(FrameInfoEncoder.Customization frameInfoCustomization, Encoders encoders) {
        this(frameInfoCustomization, encoders, FrameInfoDecoder.SubstrateConstantAccess);
    }

    public CodeInfoEncoder(FrameInfoEncoder.Customization frameInfoCustomization, Encoders encoders, FrameInfoDecoder.ConstantAccess constantAccess) {
        this.encoders = encoders;
        this.frameInfoEncoder = new FrameInfoEncoder(frameInfoCustomization, encoders, constantAccess);
    }

    public FrameInfoEncoder getFrameInfoEncoder() {
        return this.frameInfoEncoder;
    }

    public Encoders getEncoders() {
        return this.encoders;
    }

    @Fold
    public static boolean shouldEncodeAllMethodMetadata() {
        return HasJfrSupport.get() && !RuntimeCompilation.isEnabled();
    }

    public static int getEntryOffset(Infopoint infopoint) {
        if (infopoint instanceof Call || infopoint instanceof DeoptEntryInfopoint) {
            int offset = infopoint.pcOffset;
            if (infopoint instanceof Call) {
                offset += ((Call)infopoint).size;
            }
            return offset;
        }
        return -1;
    }

    public void addMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, int compilationSize) {
        FrameInfoEncoder.FrameData defaultFrameData;
        int totalFrameSize = compilation.getTotalFrameSize();
        boolean isEntryPoint = method.isEntryPoint();
        boolean hasCalleeSavedRegisters = method.hasCalleeSavedRegisters();
        IPData startEntry = this.makeEntry(compilationOffset);
        startEntry.frameData = defaultFrameData = this.frameInfoEncoder.addDefaultDebugInfo(method, totalFrameSize);
        startEntry.frameSizeEncoding = this.encodeFrameSize(totalFrameSize, true, isEntryPoint, hasCalleeSavedRegisters);
        for (long entryIP = CodeInfoDecoder.lookupEntryIP(CodeInfoDecoder.indexGranularity() + (long)compilationOffset); entryIP <= CodeInfoDecoder.lookupEntryIP(compilationSize + compilationOffset - 1); entryIP += CodeInfoDecoder.indexGranularity()) {
            IPData entry = this.makeEntry(entryIP);
            entry.frameData = defaultFrameData;
            entry.frameSizeEncoding = this.encodeFrameSize(totalFrameSize, false, isEntryPoint, hasCalleeSavedRegisters);
        }
        EconomicSet infopointOffsets = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        EconomicSet deoptEntryBcis = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (Infopoint infopoint : compilation.getInfopoints()) {
            BytecodeFrame frame;
            long encodedBci;
            int offset;
            DebugInfo debugInfo = infopoint.debugInfo;
            if (debugInfo == null || (offset = CodeInfoEncoder.getEntryOffset(infopoint)) < 0) continue;
            boolean added = infopointOffsets.add((Object)offset);
            if (!added) {
                throw VMError.shouldNotReachHere("Encoding two infopoints at same offset. Conflicting infopoint: " + String.valueOf(infopoint));
            }
            IPData entry = this.makeEntry(offset + compilationOffset);
            assert (entry.referenceMap == null && (entry.frameData == null || entry.frameData.isDefaultFrameData)) : entry;
            entry.referenceMap = (ReferenceMapEncoder.Input)debugInfo.getReferenceMap();
            entry.frameData = this.frameInfoEncoder.addDebugInfo(method, compilation, infopoint, totalFrameSize);
            if (entry.frameData == null || !entry.frameData.frame.isDeoptEntry || (added = deoptEntryBcis.add((Object)(encodedBci = FrameInfoEncoder.encodeBci((frame = debugInfo.frame()).getBCI(), FrameState.StackState.of((BytecodeFrame)frame)))))) continue;
            throw VMError.shouldNotReachHere(String.format("Encoding two deopt entries at same encoded bci: %s (bci %s)%nmethod: %s", encodedBci, FrameInfoDecoder.readableBci(encodedBci), method));
        }
        for (ExceptionHandler handler : compilation.getExceptionHandlers()) {
            IPData entry = this.makeEntry(handler.pcOffset + compilationOffset);
            assert (entry.exceptionOffset == 0) : entry;
            entry.exceptionOffset = handler.handlerPos - handler.pcOffset;
        }
        ((Counters)ImageSingletons.lookup(Counters.class)).methodCount.inc();
        ((Counters)ImageSingletons.lookup(Counters.class)).codeSize.add(compilationSize);
    }

    private IPData makeEntry(long ip) {
        IPData result = this.entries.get(ip);
        if (result == null) {
            result = new IPData();
            result.ip = ip;
            this.entries.put(ip, result);
        }
        return result;
    }

    public void encodeAllAndInstall(CodeInfo target, ReferenceAdjuster adjuster, Runnable recordActivity) {
        this.encoders.encodeAllAndInstall(target, adjuster);
        this.encodeReferenceMaps();
        this.frameInfoEncoder.encodeAllAndInstall(target, recordActivity);
        this.encodeIPData();
        this.install(target);
    }

    private void install(CodeInfo target) {
        CodeInfoAccess.setCodeInfo(target, this.codeInfoIndex, this.codeInfoEncodings, this.referenceMapEncoding);
    }

    private void encodeReferenceMaps() {
        CodeReferenceMapEncoder referenceMapEncoder = new CodeReferenceMapEncoder();
        for (IPData data : this.entries.values()) {
            referenceMapEncoder.add(data.referenceMap);
        }
        this.referenceMapEncoding = referenceMapEncoder.encodeAll();
        ((Counters)ImageSingletons.lookup(Counters.class)).addToReferenceMapSize(referenceMapEncoder.getEncodingSize());
        for (IPData data : this.entries.values()) {
            data.referenceMapIndex = referenceMapEncoder.lookupEncoding(data.referenceMap);
        }
    }

    protected int encodeFrameSize(int totalFrameSize, boolean methodStart, boolean isEntryPoint, boolean hasCalleeSavedRegisters) {
        VMError.guarantee((totalFrameSize & 7) == 0, "Frame size must be aligned");
        return totalFrameSize | (methodStart ? 1 : 0) | (isEntryPoint ? 2 : 0) | (hasCalleeSavedRegisters ? 4 : 0);
    }

    private void encodeIPData() {
        IPData first = null;
        IPData prev = null;
        for (IPData cur : this.entries.values()) {
            if (first == null) {
                first = cur;
            } else {
                while (!TypeConversion.isU1((long)(cur.ip - prev.ip))) {
                    IPData filler = new IPData();
                    filler.ip = prev.ip + 255L;
                    prev.next = filler;
                    prev = filler;
                }
                prev.next = cur;
            }
            prev = cur;
        }
        long nextIndexIP = 0L;
        UnsafeArrayTypeWriter indexBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        IPData data = first;
        while (data != null) {
            assert (data.ip <= nextIndexIP) : data;
            if (data.ip == nextIndexIP) {
                indexBuffer.putU4(encodingBuffer.getBytesWritten());
                nextIndexIP += CodeInfoDecoder.indexGranularity();
            }
            int entryFlags = 0;
            entryFlags |= CodeInfoEncoder.flagsForSizeEncoding(data) << 0;
            entryFlags |= CodeInfoEncoder.flagsForExceptionOffset(data) << 2;
            entryFlags |= CodeInfoEncoder.flagsForReferenceMapIndex(data) << 4;
            encodingBuffer.putU1((long)(entryFlags |= CodeInfoEncoder.flagsForDeoptFrameInfo(data) << 6));
            encodingBuffer.putU1(data.next == null ? 0L : data.next.ip - data.ip);
            CodeInfoEncoder.writeSizeEncoding(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeExceptionOffset(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeReferenceMapIndex(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeEncodedFrameInfo(encodingBuffer, data, entryFlags);
            data = data.next;
        }
        this.codeInfoIndex = NonmovableArrays.createByteArray(TypeConversion.asU4((long)indexBuffer.getBytesWritten()), NmtCategory.Code);
        indexBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(this.codeInfoIndex));
        this.codeInfoEncodings = NonmovableArrays.createByteArray(TypeConversion.asU4((long)encodingBuffer.getBytesWritten()), NmtCategory.Code);
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(this.codeInfoEncodings));
    }

    private static int flagsForSizeEncoding(IPData data) {
        if (data.frameSizeEncoding == 0) {
            return 0;
        }
        if (TypeConversion.isS1((long)data.frameSizeEncoding)) {
            return 1;
        }
        if (TypeConversion.isS2((long)data.frameSizeEncoding)) {
            return 2;
        }
        if (TypeConversion.isS4((long)data.frameSizeEncoding)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeSizeEncoding(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 1: {
                writeBuffer.putS1((long)data.frameSizeEncoding);
                break;
            }
            case 2: {
                writeBuffer.putS2((long)data.frameSizeEncoding);
                break;
            }
            case 3: {
                writeBuffer.putS4((long)data.frameSizeEncoding);
            }
        }
    }

    private static int flagsForExceptionOffset(IPData data) {
        if (data.exceptionOffset == 0) {
            return 0;
        }
        if (TypeConversion.isS1((long)data.exceptionOffset)) {
            return 1;
        }
        if (TypeConversion.isS2((long)data.exceptionOffset)) {
            return 2;
        }
        if (TypeConversion.isS4((long)data.exceptionOffset)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeExceptionOffset(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractEX(entryFlags)) {
            case 1: {
                writeBuffer.putS1((long)data.exceptionOffset);
                break;
            }
            case 2: {
                writeBuffer.putS2((long)data.exceptionOffset);
                break;
            }
            case 3: {
                writeBuffer.putS4((long)data.exceptionOffset);
            }
        }
    }

    private static int flagsForReferenceMapIndex(IPData data) {
        if (data.referenceMap == null) {
            return 0;
        }
        if (data.referenceMap.isEmpty()) {
            return 1;
        }
        if (TypeConversion.isU2((long)data.referenceMapIndex)) {
            return 2;
        }
        if (TypeConversion.isU4((long)data.referenceMapIndex)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeReferenceMapIndex(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractRM(entryFlags)) {
            case 2: {
                writeBuffer.putU2(data.referenceMapIndex);
                break;
            }
            case 3: {
                writeBuffer.putU4(data.referenceMapIndex);
            }
        }
    }

    private static int flagsForDeoptFrameInfo(IPData data) {
        if (data.frameData == null) {
            return 0;
        }
        if (TypeConversion.isS4((long)data.frameData.encodedFrameInfoIndex)) {
            if (data.frameData.frame.isDeoptEntry) {
                return 1;
            }
            if (data.frameData.isDefaultFrameData) {
                return 3;
            }
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static void writeEncodedFrameInfo(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 1: 
            case 2: 
            case 3: {
                writeBuffer.putS4(data.frameData.encodedFrameInfoIndex);
            }
        }
    }

    public static boolean verifyMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, int compilationSize, CodeInfo info, FrameInfoDecoder.ConstantAccess constantAccess) {
        CodeInfoVerifier verifier = new CodeInfoVerifier(constantAccess);
        verifier.verifyMethod(method, compilation, compilationOffset, compilationSize, info);
        return true;
    }

    public boolean verifyFrameInfo(CodeInfo info) {
        this.frameInfoEncoder.verifyEncoding(info);
        return true;
    }

    public static final class Encoders {
        static final Class<?> INVALID_CLASS = null;
        static final String INVALID_METHOD_NAME = "";
        static final int INVALID_METHOD_MODIFIERS = -1;
        static final String INVALID_METHOD_SIGNATURE = null;
        public final FrequencyEncoder<JavaConstant> objectConstants = FrequencyEncoder.createEqualityEncoder();
        public final FrequencyEncoder<Class<?>> classes;
        public final FrequencyEncoder<String> memberNames;
        public final FrequencyEncoder<String> otherStrings;
        private final FrequencyEncoder<Member> methods;
        private Member[] encodedMethods;

        public Encoders(boolean imageCode, Consumer<Class<?>> classVerifier) {
            assert (imageCode == SubstrateUtil.HOSTED);
            this.classes = imageCode ? FrequencyEncoder.createVerifyingEqualityEncoder(classVerifier) : null;
            this.memberNames = imageCode ? FrequencyEncoder.createEqualityEncoder() : null;
            this.methods = imageCode ? FrequencyEncoder.createEqualityEncoder() : null;
            Object object = this.otherStrings = imageCode ? FrequencyEncoder.createEqualityEncoder() : null;
            if (imageCode) {
                this.methods.addObject(null);
                this.classes.addObject(INVALID_CLASS);
                this.memberNames.addObject((Object)INVALID_METHOD_NAME);
                if (CodeInfoEncoder.shouldEncodeAllMethodMetadata()) {
                    this.otherStrings.addObject((Object)INVALID_METHOD_SIGNATURE);
                }
            }
        }

        public void addMethod(ResolvedJavaMethod method, Class<?> clazz, String name, String signature, int modifiers) {
            VMError.guarantee(SubstrateUtil.HOSTED, "Runtime code info must reference image methods by id");
            Member member = new Member(Objects.requireNonNull(method), clazz, name, signature, modifiers);
            if (this.methods.addObject((Object)member)) {
                this.classes.addObject(clazz);
                this.memberNames.addObject((Object)name);
                if (CodeInfoEncoder.shouldEncodeAllMethodMetadata()) {
                    this.otherStrings.addObject((Object)signature);
                }
            }
        }

        public int findMethodIndex(ResolvedJavaMethod method, Class<?> clazz, String name, String signature, int modifiers, boolean optional) {
            VMError.guarantee(SubstrateUtil.HOSTED, "Runtime code info must obtain method ids from image code info");
            Member member = new Member(Objects.requireNonNull(method), clazz, name, signature, modifiers);
            return optional ? this.methods.findIndex((Object)member) : this.methods.getIndex((Object)member);
        }

        public ResolvedJavaMethod[] getEncodedMethods() {
            assert (this.encodedMethods != null) : "can call only once encoded (and only for image code)";
            return (ResolvedJavaMethod[])Stream.of(this.encodedMethods).map(m -> m != null ? m.method() : null).toArray(ResolvedJavaMethod[]::new);
        }

        private void encodeAllAndInstall(CodeInfo target, ReferenceAdjuster adjuster) {
            int methodTableFirstId;
            JavaConstant[] objectConstantsArray = Encoders.encodeArray(this.objectConstants, JavaConstant[]::new);
            Class<?>[] classesArray = Encoders.encodeArray(this.classes, Class[]::new);
            String[] memberNamesArray = Encoders.encodeArray(this.memberNames, String[]::new);
            String[] otherStringsArray = Encoders.encodeArray(this.otherStrings, String[]::new);
            if (ImageLayerBuildingSupport.buildingImageLayer()) {
                MethodTableFirstIDTracker idTracker = MethodTableFirstIDTracker.singleton();
                methodTableFirstId = idTracker.startingID;
                idTracker.nextStartingId = methodTableFirstId + this.methods.getLength();
            } else {
                methodTableFirstId = 0;
            }
            NonmovableArray<Byte> methodTable = this.encodeMethodTable();
            Encoders.install(target, objectConstantsArray, classesArray, memberNamesArray, otherStringsArray, methodTable, methodTableFirstId, adjuster);
        }

        private static <T> T[] encodeArray(FrequencyEncoder<T> encoder, IntFunction<T[]> allocator) {
            if (encoder == null) {
                return null;
            }
            Object[] array = allocator.apply(encoder.getLength());
            return encoder.encodeAll(array);
        }

        private NonmovableArray<Byte> encodeMethodTable() {
            if (this.methods == null) {
                return NonmovableArrays.nullArray();
            }
            VMError.guarantee(this.encodedMethods == null, "encoded already");
            this.encodedMethods = Encoders.encodeArray(this.methods, Member[]::new);
            boolean shortClassIndexes = this.classes.getLength() <= 65535;
            boolean shortNameIndexes = this.memberNames.getLength() <= 65535;
            boolean shortSignatureIndexes = this.otherStrings.getLength() <= 65535;
            UnsafeArrayTypeWriter writer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
            assert (this.encodedMethods[0] == null) : "id 0 must mean invalid";
            this.encodeMethod(writer, INVALID_CLASS, INVALID_METHOD_NAME, INVALID_METHOD_SIGNATURE, -1, shortClassIndexes, shortNameIndexes, shortSignatureIndexes);
            for (int id = 1; id < this.encodedMethods.length; ++id) {
                this.encodeMethod(writer, this.encodedMethods[id].clazz, this.encodedMethods[id].name, this.encodedMethods[id].signature, this.encodedMethods[id].modifiers, shortClassIndexes, shortNameIndexes, shortSignatureIndexes);
            }
            NonmovableArray<Byte> bytes = NonmovableArrays.createByteArray(NumUtil.safeToInt((long)writer.getBytesWritten()), NmtCategory.Code);
            writer.toByteBuffer(NonmovableArrays.asByteBuffer(bytes));
            return bytes;
        }

        private void encodeMethod(UnsafeArrayTypeWriter writer, Class<?> clazz, String name, String signature, int modifiers, boolean shortClassIndexes, boolean shortNameIndexes, boolean shortSignatureIndexes) {
            int classIndex = this.classes.getIndex(clazz);
            if (shortClassIndexes) {
                writer.putU2((long)classIndex);
            } else {
                writer.putU4((long)classIndex);
            }
            int memberNamesIndex = this.memberNames.getIndex((Object)name);
            if (shortNameIndexes) {
                writer.putU2((long)memberNamesIndex);
            } else {
                writer.putU4((long)memberNamesIndex);
            }
            if (CodeInfoEncoder.shouldEncodeAllMethodMetadata()) {
                int signatureNamesIndex = this.otherStrings.getIndex((Object)signature);
                if (shortSignatureIndexes) {
                    writer.putU2((long)signatureNamesIndex);
                } else {
                    writer.putU4((long)signatureNamesIndex);
                }
                writer.putS2((long)modifiers);
            }
        }

        @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
        private static void install(CodeInfo target, JavaConstant[] objectConstantsArray, Class<?>[] classesArray, String[] memberNamesArray, String[] otherStringsArray, NonmovableArray<Byte> methodTable, int methodTableFirstId, ReferenceAdjuster adjuster) {
            NonmovableObjectArray objectConstants = adjuster.copyOfObjectConstantArray((Constant[])objectConstantsArray, NmtCategory.Code);
            NonmovableObjectArray<Class<?>> classes = classesArray != null ? adjuster.copyOfObjectArray(classesArray, NmtCategory.Code) : (NonmovableObjectArray<Class<?>>)NonmovableArrays.nullArray();
            NonmovableObjectArray<String> memberNames = memberNamesArray != null ? adjuster.copyOfObjectArray(memberNamesArray, NmtCategory.Code) : (NonmovableObjectArray<String>)NonmovableArrays.nullArray();
            NonmovableObjectArray<String> otherStrings = otherStringsArray != null ? adjuster.copyOfObjectArray(otherStringsArray, NmtCategory.Code) : (NonmovableObjectArray<String>)NonmovableArrays.nullArray();
            CodeInfoAccess.setEncodings(target, objectConstants, classes, memberNames, otherStrings, methodTable, methodTableFirstId);
        }

        public record Member(ResolvedJavaMethod method, Class<?> clazz, String name, String signature, int modifiers) {
        }
    }

    static class IPData {
        protected long ip;
        protected int frameSizeEncoding;
        protected int exceptionOffset;
        protected ReferenceMapEncoder.Input referenceMap;
        protected long referenceMapIndex;
        protected FrameInfoEncoder.FrameData frameData;
        protected IPData next;

        IPData() {
        }
    }

    public static class Counters {
        public final Counter.Group group = new Counter.Group(Options.CodeInfoEncoderCounters, "CodeInfoEncoder");
        final Counter methodCount = new Counter(this.group, "Number of methods", "Number of methods encoded");
        final Counter codeSize = new Counter(this.group, "Code size", "Total size of machine code");
        final Counter referenceMapSize = new Counter(this.group, "Reference map size", "Total size of encoded reference maps");
        final Counter frameInfoSize = new Counter(this.group, "Frame info size", "Total size of encoded frame information");
        final Counter frameCount = new Counter(this.group, "Number of frames", "Number of frames encoded");
        final Counter stackValueCount = new Counter(this.group, "Number of stack values", "Number of stack values encoded");
        final Counter registerValueCount = new Counter(this.group, "Number of register values", "Number of register values encoded");
        final Counter constantValueCount = new Counter(this.group, "Number of constant values", "Number of constant values encoded");
        final Counter virtualObjectsCount = new Counter(this.group, "Number of virtual objects", "Number of virtual objects encoded");

        public void addToReferenceMapSize(long size) {
            this.referenceMapSize.add(size);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> CodeInfoEncoderCounters = new HostedOptionKey<Boolean>(false);
    }
}

