/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.graal.pointsto.util.GraalAccess;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.internal.misc.Unsafe;

public class IdentityHashCodeUtil {
    public static final int UNINITIALIZED = -1;
    public static final int NOT_RETRIEVABLE = -2;
    public static final int UNKNOWN = -3;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final GraalHotSpotVMConfig config = (GraalHotSpotVMConfig)GraalAccess.getGraalCapability(GraalHotSpotVMConfig.class);
    private static final long hashCodeMask = NumUtil.getNbitNumberLong((int)31) << IdentityHashCodeUtil.config.identityHashCodeShift;

    public static int readIdentityHashCode(Object obj) {
        if (obj == null) {
            return -2;
        }
        return IdentityHashCodeUtil.readIdentityHashCode(IdentityHashCodeUtil.readMarkWord(obj));
    }

    public static boolean injectIdentityHashCode(Object obj, int requestedHashCode) {
        int hashCode = IdentityHashCodeUtil.tryInjectIdentityHashCode(obj, requestedHashCode);
        return hashCode == requestedHashCode;
    }

    public static int tryInjectIdentityHashCode(Object obj, int requestedHashCode) {
        long markWord;
        assert (NumUtil.isUnsignedNbit((int)31, (int)requestedHashCode)) : Assertions.errorMessage((Object[])new Object[]{"Injected hashcode should be a 31-bit unsigned value", requestedHashCode});
        if (obj == null) {
            return -2;
        }
        do {
            int currentHashCode;
            if ((currentHashCode = IdentityHashCodeUtil.readIdentityHashCode(markWord = IdentityHashCodeUtil.readMarkWord(obj))) == -1) continue;
            return currentHashCode;
        } while (!IdentityHashCodeUtil.trySetIdentityHashCode(obj, markWord, requestedHashCode));
        return requestedHashCode;
    }

    private static long readMarkWord(Object obj) {
        return unsafe.getLong(obj, IdentityHashCodeUtil.config.markOffset);
    }

    private static int readIdentityHashCode(long markWord) {
        boolean containsHashCode;
        long lockBits = markWord & (long)IdentityHashCodeUtil.config.lockMaskInPlace;
        if (IdentityHashCodeUtil.config.lockingMode == IdentityHashCodeUtil.config.lockingModeLightweight) {
            containsHashCode = lockBits != (long)IdentityHashCodeUtil.config.monitorMask;
        } else {
            boolean bl = containsHashCode = lockBits == (long)IdentityHashCodeUtil.config.unlockedMask;
        }
        if (containsHashCode) {
            int hashcode = (int)(markWord >>> IdentityHashCodeUtil.config.identityHashCodeShift);
            if (hashcode == IdentityHashCodeUtil.config.uninitializedIdentityHashCodeValue) {
                return -1;
            }
            return hashcode;
        }
        return -3;
    }

    private static boolean trySetIdentityHashCode(Object obj, long originalMarkWord, int hashCode) {
        long newMarkWord = IdentityHashCodeUtil.config.uninitializedIdentityHashCodeValue == 0 ? originalMarkWord | (long)hashCode << IdentityHashCodeUtil.config.identityHashCodeShift : originalMarkWord & (hashCodeMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)hashCode << IdentityHashCodeUtil.config.identityHashCodeShift;
        return unsafe.compareAndSetLong(obj, IdentityHashCodeUtil.config.markOffset, originalMarkWord, newMarkWord);
    }
}

