/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public class VMThreadLocalCollector
implements Function<Object, Object> {
    final Map<FastThreadLocal, VMThreadLocalInfo> threadLocals = ObservableImageHeapMapProvider.create();
    private boolean sealed;

    @Override
    public Object apply(Object source) {
        if (source instanceof FastThreadLocal) {
            FastThreadLocal threadLocal = (FastThreadLocal)source;
            if (this.sealed) {
                assert (this.threadLocals.containsKey(threadLocal)) : "VMThreadLocal must have been discovered during static analysis";
            } else {
                this.threadLocals.putIfAbsent(threadLocal, new VMThreadLocalInfo(threadLocal));
            }
        }
        return source;
    }

    public VMThreadLocalInfo getInfo(FastThreadLocal threadLocal) {
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        assert (result != null);
        return result;
    }

    public VMThreadLocalInfo findInfo(GraphBuilderContext b, ValueNode threadLocalNode) {
        if (!threadLocalNode.isConstant()) {
            throw VMError.shouldNotReachHere("Accessed VMThreadLocal is not a compile time constant: " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())) + " - node " + String.valueOf(VMThreadLocalCollector.unPi(threadLocalNode)));
        }
        FastThreadLocal threadLocal = (FastThreadLocal)b.getSnippetReflection().asObject(FastThreadLocal.class, threadLocalNode.asJavaConstant());
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        assert (result != null);
        return result;
    }

    public List<VMThreadLocalInfo> sortThreadLocals() {
        this.sealed = true;
        for (VMThreadLocalInfo info : this.threadLocals.values()) {
            assert (info.sizeInBytes == -1);
            if (info.sizeSupplier != null) {
                int unalignedSize = info.sizeSupplier.getAsInt();
                assert (unalignedSize > 0);
                info.sizeInBytes = NumUtil.roundUp((int)unalignedSize, (int)8);
                continue;
            }
            info.sizeInBytes = ConfigurationValues.getObjectLayout().sizeInBytes(info.storageKind);
        }
        ArrayList<VMThreadLocalInfo> sortedThreadLocals = new ArrayList<VMThreadLocalInfo>(this.threadLocals.values());
        sortedThreadLocals.sort(VMThreadLocalCollector::compareThreadLocal);
        return sortedThreadLocals;
    }

    private static int compareThreadLocal(VMThreadLocalInfo info1, VMThreadLocalInfo info2) {
        if (info1 == info2) {
            return 0;
        }
        int result = Integer.compare(info1.maxOffset, info2.maxOffset);
        if (result == 0 && (result = -Integer.compare(info1.sizeInBytes, info2.sizeInBytes)) == 0 && (result = -Boolean.compare(info1.isObject, info2.isObject)) == 0) {
            result = info1.name.compareTo(info2.name);
        }
        return result;
    }

    private static ValueNode unPi(ValueNode n) {
        ValueNode cur = n;
        while (cur instanceof PiNode) {
            cur = ((PiNode)cur).object();
        }
        return cur;
    }
}

