/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.ImageLayerSection;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.code.ObjectFileTransformer;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfoFeature;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
public final class ImageLayerSectionFeature
implements InternalFeature,
FeatureSingleton,
UnsavedSingleton,
ObjectFileTransformer {
    private static final SectionName SVM_LAYER_SECTION = new SectionName.ProgbitsSectionName("svm_layer");
    private static final int HEAP_BEGIN_OFFSET = 0;
    private static final int HEAP_END_OFFSET = 8;
    private static final int HEAP_RELOCATABLE_BEGIN_OFFSET = 16;
    private static final int HEAP_RELOCATABLE_END_OFFSET = 24;
    private static final int HEAP_ANY_RELOCATABLE_POINTER_OFFSET = 32;
    private static final int HEAP_WRITABLE_BEGIN_OFFSET = 40;
    private static final int HEAP_WRITABLE_END_OFFSET = 48;
    private static final int NEXT_SECTION_OFFSET = 56;
    private static final int SECTION_SIZE = 64;
    private static final String CACHED_IMAGE_FDS_NAME = "__svm_layer_cached_image_fds";
    private static final String CACHED_IMAGE_HEAP_OFFSETS_NAME = "__svm_layer_cached_image_heap_offsets";
    private static final SignedWord UNASSIGNED_FD = WordFactory.signed((int)-1);
    private ObjectFile.ProgbitsSectionImpl layeredSectionData;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(HostedDynamicLayerInfoFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ImageLayerSection.class, (Object)ImageLayerSectionFeature.createImageLayerSection());
        ImageSingletons.add(ObjectFileTransformer.class, (Object)this);
    }

    private static byte[] createWords(int count, WordBase initialValue) {
        Architecture arch = ConfigurationValues.getTarget().arch;
        assert (arch.getWordSize() == 8) : "currently hard-coded for 8 byte words";
        ByteBuffer buffer = ByteBuffer.allocate(count * 8).order(arch.getByteOrder());
        for (int i = 0; i < count; ++i) {
            buffer.putLong(initialValue.rawValue());
        }
        return buffer.array();
    }

    private static String getLayerName(int layerNumber) {
        return String.format("__svm_layer_%s", layerNumber);
    }

    private static ImageLayerSectionImpl createImageLayerSection() {
        CGlobalData<WordPointer> cachedImageHeapOffsets;
        CGlobalData<WordPointer> cachedImageFDs;
        CGlobalData<Pointer> initialSectionStart;
        CGlobalData<Pointer> cGlobalData = initialSectionStart = ImageLayerBuildingSupport.buildingInitialLayer() ? CGlobalDataFactory.forSymbol(ImageLayerSectionFeature.getLayerName(DynamicImageLayerInfo.singleton().layerNumber)) : null;
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            cachedImageFDs = CGlobalDataFactory.forSymbol(CACHED_IMAGE_FDS_NAME);
            cachedImageHeapOffsets = CGlobalDataFactory.forSymbol(CACHED_IMAGE_HEAP_OFFSETS_NAME);
        } else if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            cachedImageFDs = CGlobalDataFactory.createBytes(() -> ImageLayerSectionFeature.createWords(DynamicImageLayerInfo.singleton().numLayers, (WordBase)UNASSIGNED_FD), CACHED_IMAGE_FDS_NAME);
            cachedImageHeapOffsets = CGlobalDataFactory.createBytes(() -> ImageLayerSectionFeature.createWords(DynamicImageLayerInfo.singleton().numLayers, WordFactory.zero()), CACHED_IMAGE_HEAP_OFFSETS_NAME);
        } else {
            cachedImageFDs = null;
            cachedImageHeapOffsets = null;
        }
        return new ImageLayerSectionImpl(initialSectionStart, cachedImageFDs, cachedImageHeapOffsets);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            CGlobalDataFeature.singleton().registerWithGlobalSymbol(ImageLayerSection.getCachedImageFDs());
            CGlobalDataFeature.singleton().registerWithGlobalSymbol(ImageLayerSection.getCachedImageHeapOffsets());
        }
    }

    @Override
    public void afterAbstractImageCreation(ObjectFile objectFile) {
        byte[] sectionBytes = new byte[64];
        this.layeredSectionData = new BasicProgbitsSectionImpl(sectionBytes);
        ObjectFile.Section layeredImageSection = objectFile.newProgbitsSection(SVM_LAYER_SECTION.getFormatDependentName(objectFile.getFormat()), objectFile.getPageSize(), true, false, this.layeredSectionData);
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            String nextLayerSymbolName = ImageLayerSectionFeature.getLayerName(DynamicImageLayerInfo.singleton().nextLayerNumber);
            objectFile.createUndefinedSymbol(nextLayerSymbolName, 0, false);
            this.layeredSectionData.markRelocationSite(56, ObjectFile.RelocationKind.DIRECT_8, nextLayerSymbolName, 0L);
        }
        objectFile.createDefinedSymbol(ImageLayerSectionFeature.getLayerName(DynamicImageLayerInfo.singleton().layerNumber), (ObjectFile.Element)layeredImageSection, 0L, 0, false, ImageLayerBuildingSupport.buildingExtensionLayer());
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        this.layeredSectionData.markRelocationSite(0, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_begin", 0L);
        this.layeredSectionData.markRelocationSite(8, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_end", 0L);
        this.layeredSectionData.markRelocationSite(16, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_relocatable_begin", 0L);
        this.layeredSectionData.markRelocationSite(24, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_relocatable_end", 0L);
        this.layeredSectionData.markRelocationSite(32, ObjectFile.RelocationKind.DIRECT_8, "__svm_a_relocatable_pointer", 0L);
        this.layeredSectionData.markRelocationSite(40, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_writable_begin", 0L);
        this.layeredSectionData.markRelocationSite(48, ObjectFile.RelocationKind.DIRECT_8, "__svm_heap_writable_end", 0L);
    }

    private static class ImageLayerSectionImpl
    extends ImageLayerSection
    implements UnsavedSingleton {
        ImageLayerSectionImpl(CGlobalData<Pointer> initialSectionStart, CGlobalData<WordPointer> cachedImageFDs, CGlobalData<WordPointer> cachedImageHeapOffsets) {
            super(initialSectionStart, cachedImageFDs, cachedImageHeapOffsets);
        }

        @Override
        public int getEntryOffsetInternal(ImageLayerSection.SectionEntries entry) {
            return switch (entry) {
                default -> throw new MatchException(null, null);
                case ImageLayerSection.SectionEntries.HEAP_BEGIN -> 0;
                case ImageLayerSection.SectionEntries.HEAP_END -> 8;
                case ImageLayerSection.SectionEntries.HEAP_RELOCATABLE_BEGIN -> 16;
                case ImageLayerSection.SectionEntries.HEAP_RELOCATABLE_END -> 24;
                case ImageLayerSection.SectionEntries.HEAP_ANY_RELOCATABLE_POINTER -> 32;
                case ImageLayerSection.SectionEntries.HEAP_WRITEABLE_BEGIN -> 40;
                case ImageLayerSection.SectionEntries.HEAP_WRITEABLE_END -> 48;
                case ImageLayerSection.SectionEntries.NEXT_SECTION -> 56;
            };
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }
    }
}

