/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.BaseLayerPartition;
import com.oracle.svm.hosted.image.ImageHeapConnectedComponentsFeature;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class NativeImageHeap
implements ImageHeap {
    private static final ImageHeapPartition BASE_LAYER_PARTITION = new BaseLayerPartition();
    public final AnalysisUniverse aUniverse;
    public final HostedUniverse hUniverse;
    public final HostedMetaAccess hMetaAccess;
    public final HostedConstantReflectionProvider hConstantReflection;
    public final ObjectLayout objectLayout;
    public final DynamicHubLayout dynamicHubLayout;
    private final ImageHeapLayouter heapLayouter;
    private final int minInstanceSize;
    private final int minArraySize;
    private final HashMap<JavaConstant, ObjectInfo> objects = new HashMap();
    private final Set<Object> blacklist = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<HostedClass, HybridLayout> hybridLayouts = new HashMap<HostedClass, HybridLayout>();
    private final Map<String, String> internedStrings = new HashMap<String, String>();
    private final Phase addObjectsPhase = Phase.factory();
    private final Phase internStringsPhase = Phase.factory();
    private final Deque<AddObjectData> addObjectWorklist = new ArrayDeque<AddObjectData>();
    private final Set<Object> knownImmutableObjects = Collections.newSetFromMap(new IdentityHashMap());
    Map<ObjectInfo, ObjectReachabilityInfo> objectReachabilityInfo = null;

    public NativeImageHeap(AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, HostedConstantReflectionProvider hConstantReflection, ImageHeapLayouter heapLayouter) {
        this.aUniverse = aUniverse;
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.hConstantReflection = hConstantReflection;
        this.objectLayout = ConfigurationValues.getObjectLayout();
        this.heapLayouter = heapLayouter;
        this.minInstanceSize = this.objectLayout.getMinImageHeapInstanceSize();
        this.minArraySize = this.objectLayout.getMinImageHeapArraySize();
        assert (this.assertFillerObjectSizes());
        this.dynamicHubLayout = DynamicHubLayout.singleton();
        if (ImageHeapConnectedComponentsFeature.Options.PrintImageHeapConnectedComponents.getValue().booleanValue()) {
            this.objectReachabilityInfo = new IdentityHashMap<ObjectInfo, ObjectReachabilityInfo>();
        }
    }

    public Collection<ObjectInfo> getObjects() {
        return this.objects.values();
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public int getLayerObjectCount() {
        return (int)this.objects.values().stream().filter(o -> !o.constant.isInBaseLayer()).count();
    }

    public ObjectInfo getObjectInfo(Object obj) {
        JavaConstant constant = this.hUniverse.getSnippetReflection().forObject(obj);
        VMError.guarantee(constant instanceof ImageHeapConstant, "Expected an ImageHeapConstant, found %s", constant);
        return this.objects.get(CompressibleConstant.uncompress((JavaConstant)constant));
    }

    public ObjectInfo getConstantInfo(JavaConstant constant) {
        VMError.guarantee(constant instanceof ImageHeapConstant, "Expected an ImageHeapConstant, found %s", constant);
        return this.objects.get(CompressibleConstant.uncompress((JavaConstant)constant));
    }

    protected HybridLayout getHybridLayout(HostedClass clazz) {
        return this.hybridLayouts.get(clazz);
    }

    protected boolean isBlacklisted(Object obj) {
        return this.blacklist.contains(obj);
    }

    public ImageHeapLayouter getLayouter() {
        return this.heapLayouter;
    }

    @Fold
    static boolean useHeapBase() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static boolean spawnIsolates() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && NativeImageHeap.useHeapBase();
    }

    public void addInitialObjects() {
        this.addObjectsPhase.allow();
        this.internStringsPhase.allow();
        this.addStaticFields();
    }

    public void addTrailingObjects() {
        boolean usesInternedStrings;
        this.processAddObjectWorklist();
        HostedField hostedField = this.hMetaAccess.optionalLookupJavaField(StringInternSupport.getInternedStringsField());
        boolean bl = usesInternedStrings = hostedField != null && hostedField.isAccessed();
        if (usesInternedStrings) {
            this.addObject(this.hMetaAccess.lookupJavaType((Class)String[].class).getHub(), false, (Object)HeapInclusionReason.InternedStringsTable);
            this.internStringsPhase.disallow();
            Object[] imageInternedStrings = this.internedStrings.keySet().toArray(new String[0]);
            Arrays.sort(imageInternedStrings);
            ((StringInternSupport)ImageSingletons.lookup(StringInternSupport.class)).setImageInternedStrings((String[])imageInternedStrings);
            if (ImageLayerBuildingSupport.buildingSharedLayer()) {
                HostedImageLayerBuildingSupport.singleton().getWriter().setImageInternedStrings((String[])imageInternedStrings);
            }
            this.aUniverse.getHeapScanner().rescanObject((Object)imageInternedStrings, ObjectScanner.OtherReason.LATE_SCAN);
            this.addObject(imageInternedStrings, true, (Object)HeapInclusionReason.InternedStringsTable);
            this.processAddObjectWorklist();
        } else {
            this.internStringsPhase.disallow();
        }
        this.addObjectsPhase.disallow();
        assert (this.addObjectWorklist.isEmpty());
    }

    Object readInlinedField(HostedField field, JavaConstant receiver) {
        VMError.guarantee(HostedConfiguration.isInlinedField(field), "Expected an inlined field, found %s", field);
        JavaConstant hostedReceiver = ((ImageHeapInstance)receiver).getHostedObject();
        HostedValuesProvider hostedValuesProvider = this.aUniverse.getHostedValuesProvider();
        return this.hUniverse.getSnippetReflection().asObject(Object.class, hostedValuesProvider.readFieldValueWithReplacement(field.getWrapped(), hostedReceiver));
    }

    private JavaConstant readConstantField(HostedField field, JavaConstant receiver) {
        return this.hConstantReflection.readFieldValue(field, receiver);
    }

    private void addStaticFields() {
        this.addObject(StaticFieldsSupport.getStaticObjectFields(), false, (Object)HeapInclusionReason.StaticObjectFields);
        this.addObject(StaticFieldsSupport.getStaticPrimitiveFields(), false, (Object)HeapInclusionReason.StaticPrimitiveFields);
        for (HostedField field : this.hUniverse.getFields()) {
            if (field.wrapped.isInBaseLayer() || !Modifier.isStatic(field.getModifiers()) || !field.hasLocation() || field.getType().getStorageKind() != JavaKind.Object || !field.isRead()) continue;
            assert (field.isWritten() || !field.isValueAvailable() || MaterializedConstantFields.singleton().contains(field.wrapped));
            this.addConstant(this.readConstantField(field, null), false, field);
        }
    }

    public void registerAsImmutable(Object object) {
        assert (this.addObjectsPhase.isBefore()) : "Registering immutable object too late: phase: " + this.addObjectsPhase.toString();
        this.knownImmutableObjects.add(object);
    }

    public void registerAsImmutable(Object root, Predicate<Object> includeObject) {
        ArrayDeque<Object> worklist = new ArrayDeque<Object>();
        IdentityHashMap<Object, Boolean> registeredObjects = new IdentityHashMap<Object, Boolean>();
        worklist.push(root);
        while (!worklist.isEmpty()) {
            Object cur = worklist.pop();
            this.registerAsImmutable(cur);
            if (this.hMetaAccess.optionalLookupJavaType(cur.getClass()).isEmpty()) {
                throw VMError.shouldNotReachHere("Type missing from static analysis: " + cur.getClass().getTypeName());
            }
            if (cur instanceof Object[]) {
                for (Object element : (Object[])cur) {
                    NativeImageHeap.addToWorklist(this.aUniverse.replaceObject(element), includeObject, worklist, registeredObjects);
                }
                continue;
            }
            JavaConstant constant = this.hUniverse.getSnippetReflection().forObject(cur);
            for (HostedField field : this.hMetaAccess.lookupJavaType(constant).getInstanceFields(true)) {
                if (!field.isAccessed() || field.getStorageKind() != JavaKind.Object) continue;
                Object fieldValue = this.hUniverse.getSnippetReflection().asObject(Object.class, this.hConstantReflection.readFieldValue(field, constant));
                NativeImageHeap.addToWorklist(fieldValue, includeObject, worklist, registeredObjects);
            }
        }
    }

    private static void addToWorklist(Object object, Predicate<Object> includeObject, Deque<Object> worklist, IdentityHashMap<Object, Boolean> registeredObjects) {
        if (object == null || registeredObjects.containsKey(object)) {
            return;
        }
        if (object instanceof DynamicHub || object instanceof Class) {
            return;
        }
        if (!includeObject.test(object)) {
            return;
        }
        registeredObjects.put(object, Boolean.TRUE);
        worklist.push(object);
    }

    public void addObject(Object original, boolean immutableFromParent, Object reason) {
        this.addConstant(this.hUniverse.getSnippetReflection().forObject(original), immutableFromParent, reason);
    }

    public void addConstant(JavaConstant constant, boolean immutableFromParent, Object reason) {
        ObjectInfo existing;
        DynamicHub hub;
        assert (this.addObjectsPhase.isAllowed()) : "Objects cannot be added at phase: " + this.addObjectsPhase.toString() + " with reason: " + String.valueOf(reason);
        if (constant.getJavaKind().isPrimitive() || constant.isNull() || this.hMetaAccess.isInstanceOf(constant, WordBase.class)) {
            return;
        }
        if (this.hMetaAccess.isInstanceOf(constant, Class.class) && (hub = (DynamicHub)this.hUniverse.getSnippetReflection().asObject(DynamicHub.class, constant)).getClassInitializationInfo() == null) {
            throw NativeImageHeap.reportIllegalType(hub, reason, "Missing class initialization info for " + hub.getName() + " type.");
        }
        JavaConstant uncompressed = CompressibleConstant.uncompress((JavaConstant)constant);
        int identityHashCode = this.computeIdentityHashCode(uncompressed);
        VMError.guarantee(identityHashCode != 0, "0 is used as a marker value for 'hash code not yet computed'");
        Object objectConstant = this.hUniverse.getSnippetReflection().asObject(Object.class, uncompressed);
        ImageHeapScanner.maybeForceHashCodeComputation((Object)objectConstant);
        if (objectConstant instanceof String) {
            String stringConstant = (String)objectConstant;
            this.handleImageString(stringConstant);
        }
        if ((existing = this.getConstantInfo(uncompressed)) == null) {
            this.addObjectToImageHeap(uncompressed, immutableFromParent, identityHashCode, reason);
        } else if (this.objectReachabilityInfo != null) {
            this.objectReachabilityInfo.get(existing).addReason(reason);
        }
    }

    private int computeIdentityHashCode(JavaConstant constant) {
        return this.hConstantReflection.identityHashCode(constant);
    }

    @Override
    public int countDynamicHubs() {
        int count = 0;
        for (ObjectInfo o : this.getObjects()) {
            if (o.constant.isInBaseLayer() || !this.hMetaAccess.isInstanceOf((JavaConstant)o.getConstant(), DynamicHub.class)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ObjectInfo addFillerObject(int size) {
        if (size >= this.minArraySize) {
            int elementSize = this.objectLayout.getArrayIndexScale(JavaKind.Int);
            int arrayLength = (size - this.minArraySize) / elementSize;
            assert (this.objectLayout.getArraySize(JavaKind.Int, arrayLength, true) == (long)size);
            return this.addLateToImageHeap(new int[arrayLength], (Object)HeapInclusionReason.FillerObject);
        }
        if (size >= this.minInstanceSize) {
            return this.addLateToImageHeap(new FillerObject(), (Object)HeapInclusionReason.FillerObject);
        }
        return null;
    }

    private boolean assertFillerObjectSizes() {
        assert ((long)this.minArraySize == this.objectLayout.getArraySize(JavaKind.Int, 0, true));
        ResolvedJavaType filler = this.hMetaAccess.lookupJavaType((Class)FillerObject.class);
        UnsignedWord fillerSize = LayoutEncoding.getPureInstanceSize(filler.getHub(), true);
        assert (fillerSize.equal(this.minInstanceSize));
        assert (this.minInstanceSize * 2 >= this.minArraySize) : "otherwise, we might need more than one non-array object";
        return true;
    }

    private void handleImageString(String str) {
        if (HostedStringDeduplication.isInternedString(str)) {
            assert (this.internedStrings.containsKey(str) || this.internStringsPhase.isAllowed()) : "Should not intern string during phase " + this.internStringsPhase.toString();
            this.internedStrings.put(str, str);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addObjectToImageHeap(JavaConstant constant, boolean immutableFromParent, int identityHashCode, Object reason) {
        type = this.hMetaAccess.lookupJavaType(constant);
        hub = type.getHub();
        immutable = immutableFromParent != false || this.isKnownImmutableConstant(constant) != false;
        written = false;
        references = false;
        relocatable = false;
        if (!type.isInstantiated()) {
            msg = new StringBuilder();
            msg.append("Image heap writing found an object whose type was not marked as instantiated by the static analysis: ");
            msg.append(type.toJavaName(true)).append("  (").append(type).append(")");
            msg.append(System.lineSeparator()).append("  reachable through:").append(System.lineSeparator());
            NativeImageHeap.fillReasonStack(msg, reason);
            VMError.shouldNotReachHere(msg.toString());
        }
        if (type.isInstanceClass()) {
            clazz = (HostedInstanceClass)type;
            if (clazz.getMonitorFieldOffset() != 0) {
                written = true;
                references = true;
            }
            if (this.dynamicHubLayout.isDynamicHub(clazz)) {
                if (SubstrateOptions.closedTypeWorld()) {
                    typeIDSlots = this.readInlinedField(this.dynamicHubLayout.closedTypeWorldTypeCheckSlotsField, constant);
                    if (!NativeImageHeap.$assertionsDisabled && typeIDSlots == null) {
                        throw new AssertionError((Object)("Cannot read value for field " + this.dynamicHubLayout.closedTypeWorldTypeCheckSlotsField.format("%H.%n")));
                    }
                    this.blacklist.add(typeIDSlots);
                } else if (SubstrateUtil.assertionsEnabled()) {
                    typeIDSlots = this.readInlinedField(this.dynamicHubLayout.closedTypeWorldTypeCheckSlotsField, constant);
                    if (!NativeImageHeap.$assertionsDisabled && typeIDSlots != null) {
                        throw new AssertionError(typeIDSlots);
                    }
                }
                hybridArray = vTable = this.readInlinedField(this.dynamicHubLayout.vTableField, constant);
                if (!NativeImageHeap.$assertionsDisabled && vTable == null) {
                    throw new AssertionError((Object)("Cannot read value for field " + this.dynamicHubLayout.vTableField.format("%H.%n")));
                }
                this.blacklist.add(vTable);
                size = this.dynamicHubLayout.getTotalSize(Array.getLength(vTable));
                ignoredFields = this.dynamicHubLayout.getIgnoredFields();
            } else if (HybridLayout.isHybrid(clazz)) {
                hybridLayout = this.hybridLayouts.get(clazz);
                if (hybridLayout == null) {
                    hybridLayout = new HybridLayout((HostedInstanceClass)clazz, this.objectLayout, (MetaAccessProvider)this.hMetaAccess);
                    this.hybridLayouts.put(clazz, hybridLayout);
                }
                shouldBlacklist = HybridLayout.canHybridFieldsBeDuplicated(clazz) == false;
                hybridArrayField = hybridLayout.getArrayField();
                hybridArray = this.readInlinedField(hybridArrayField, constant);
                ignoredFields = Set.of(hybridArrayField);
                if (hybridArray != null && shouldBlacklist) {
                    this.blacklist.add(hybridArray);
                    written = true;
                }
                if (!NativeImageHeap.$assertionsDisabled && hybridArray == null) {
                    throw new AssertionError((Object)("Cannot read value for field " + hybridArrayField.format("%H.%n")));
                }
                size = hybridLayout.getTotalSize(Array.getLength(hybridArray), true);
            } else {
                ignoredFields = Set.of();
                hybridArray = null;
                size = LayoutEncoding.getPureInstanceSize(hub, true).rawValue();
            }
            info = this.addToImageHeap(constant, clazz, size, identityHashCode, reason);
            if (this.processBaseLayerConstant(constant, info)) {
                return;
            }
            try {
                this.recursiveAddObject(hub, false, info);
                fieldsAreImmutable = this.hMetaAccess.isInstanceOf(constant, String.class);
                for (HostedField field : clazz.getInstanceFields(true)) {
                    fieldRelocatable = false;
                    if (field.isRead() && field.isValueAvailable() && !ignoredFields.contains(field)) {
                        if (field.getJavaKind() == JavaKind.Object) {
                            if (!NativeImageHeap.$assertionsDisabled && !field.hasLocation()) {
                                throw new AssertionError();
                            }
                            fieldValueConstant = this.hConstantReflection.readFieldValue(field, constant);
                            if (fieldValueConstant.getJavaKind() == JavaKind.Object) {
                                if (NativeImageHeap.spawnIsolates()) {
                                    fieldRelocatable = fieldValueConstant instanceof RelocatableConstant;
                                }
                                this.recursiveAddConstant(fieldValueConstant, fieldsAreImmutable, info);
                                references = true;
                            }
                        }
                        relocatable = relocatable != false || fieldRelocatable != false;
                    }
                    written = written != false || (field.isWritten() != false || field.isValueAvailable() == false) && field.isFinal() == false && fieldRelocatable == false;
                }
                if (!(hybridArray instanceof Object[])) ** GOTO lbl110
                relocatable = this.addArrayElements((Object[])hybridArray, relocatable, info);
                references = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else if (type.isArray()) {
            clazz = (HostedArrayClass)type;
            length = this.hConstantReflection.readArrayLength(constant);
            size = this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), length, true);
            info = this.addToImageHeap(constant, clazz, size, identityHashCode, reason);
            if (this.processBaseLayerConstant(constant, info)) {
                return;
            }
            try {
                this.recursiveAddObject(hub, false, info);
                if (this.hMetaAccess.isInstanceOf(constant, Object[].class)) {
                    VMError.guarantee(constant instanceof ImageHeapConstant, "Expected an ImageHeapConstant, found %s", constant);
                    relocatable = this.addConstantArrayElements(constant, length, false, info);
                    references = true;
                }
                written = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(type);
        }
lbl110:
        // 3 sources

        if (!(!relocatable || this.isKnownImmutableConstant(constant) || constant instanceof ImageHeapConstant && (imageHeapConstant = (ImageHeapConstant)constant).isInBaseLayer())) {
            VMError.shouldNotReachHere("Object with relocatable pointers must be explicitly immutable: " + String.valueOf(this.hUniverse.getSnippetReflection().asObject(Object.class, constant)));
        }
        this.heapLayouter.assignObjectToPartition(info, written == false || immutable != false, references, relocatable);
    }

    private boolean processBaseLayerConstant(JavaConstant constant, ObjectInfo info) {
        if (((ImageHeapConstant)constant).isInBaseLayer()) {
            info.setOffsetInPartition(this.aUniverse.getImageLayerLoader().getObjectOffset(constant));
            info.setHeapPartition(BASE_LAYER_PARTITION);
            return true;
        }
        return false;
    }

    private static HostedType requireType(Optional<HostedType> optionalType, Object object, Object reason) {
        if (optionalType.isEmpty()) {
            throw NativeImageHeap.reportIllegalType(object, reason, "Analysis type is missing for hosted object of " + object.getClass().getTypeName() + " class.");
        }
        HostedType hostedType = optionalType.get();
        if (!hostedType.isInstantiated()) {
            throw NativeImageHeap.reportIllegalType(object, reason, "Type " + hostedType.toJavaName() + " was not marked instantiated.");
        }
        return hostedType;
    }

    static RuntimeException reportIllegalType(Object object, Object reason) {
        throw NativeImageHeap.reportIllegalType(object, reason, "");
    }

    static RuntimeException reportIllegalType(Object object, Object reason, String problem) {
        StringBuilder msg = new StringBuilder();
        msg.append("Problem during heap layout: ").append(problem).append(" ");
        msg.append("The static analysis may have missed a type. ");
        msg.append("Did a static field or an object referenced from a static field change during native image generation? ");
        msg.append("For example, a lazily initialized cache could have been initialized during image generation, in which case ");
        msg.append("you need to force eager initialization of the cache before static analysis or reset the cache using a field ");
        msg.append("value recomputation.").append(System.lineSeparator()).append("    ");
        if (object instanceof DynamicHub) {
            msg.append("class: ").append(((DynamicHub)object).getName());
        } else if (object instanceof ResolvedJavaType) {
            msg.append("class: ").append(((ResolvedJavaType)object).toJavaName(true));
        } else {
            msg.append("object: ").append(object).append("  of class: ").append(object.getClass().getTypeName());
        }
        msg.append(System.lineSeparator()).append("  reachable through:").append(System.lineSeparator());
        NativeImageHeap.fillReasonStack(msg, reason);
        throw UserError.abort("%s", msg);
    }

    private static StringBuilder fillReasonStack(StringBuilder msg, Object reason) {
        if (reason instanceof ObjectInfo) {
            ObjectInfo info = (ObjectInfo)reason;
            msg.append("    object: ").append(info.getObject()).append("  of class: ").append(info.getObject().getClass().getTypeName()).append(System.lineSeparator());
            return NativeImageHeap.fillReasonStack(msg, info.getMainReason());
        }
        return msg.append("    root: ").append(reason).append(System.lineSeparator());
    }

    private boolean isKnownImmutableConstant(JavaConstant constant) {
        ImageHeapConstant imageHeapConstant;
        if (constant instanceof ImageHeapConstant && !(imageHeapConstant = (ImageHeapConstant)constant).isBackedByHostedObject()) {
            return false;
        }
        Object obj = this.hUniverse.getSnippetReflection().asObject(Object.class, constant);
        return UniverseBuilder.isKnownImmutableType(obj.getClass()) || this.knownImmutableObjects.contains(obj);
    }

    private ObjectInfo addToImageHeap(Object object, HostedClass clazz, long size, int identityHashCode, Object reason) {
        return this.addToImageHeap(this.hUniverse.getSnippetReflection().forObject(object), clazz, size, identityHashCode, reason);
    }

    private ObjectInfo addToImageHeap(JavaConstant add, HostedClass clazz, long size, int identityHashCode, Object reason) {
        VMError.guarantee(add instanceof ImageHeapConstant, "Expected an ImageHeapConstant, found %s", add);
        VMError.guarantee(!CompressibleConstant.isCompressed((JavaConstant)add), "Constants added to the image heap must be uncompressed.");
        ObjectInfo info = new ObjectInfo((ImageHeapConstant)add, size, clazz, identityHashCode, reason);
        ObjectInfo previous = this.objects.putIfAbsent(add, info);
        VMError.guarantee(previous == null, "Found an existing object info associated to constant %s", add);
        return info;
    }

    @Override
    public ObjectInfo addLateToImageHeap(Object object, Object reason) {
        assert (!(object instanceof DynamicHub)) : "needs a different identity hashcode";
        assert (!(object instanceof String)) : "needs String interning";
        this.aUniverse.getHeapScanner().rescanObject(object, ObjectScanner.OtherReason.LATE_SCAN);
        Optional<HostedType> optionalType = this.hMetaAccess.optionalLookupJavaType(object.getClass());
        HostedType type = NativeImageHeap.requireType(optionalType, object, reason);
        return this.addToImageHeap(object, (HostedClass)type, this.getSize(object, type), System.identityHashCode(object), reason);
    }

    private long getSize(Object object, HostedType type) {
        if (type.isInstanceClass()) {
            HostedInstanceClass clazz = (HostedInstanceClass)type;
            assert (!HostedConfiguration.isArrayLikeLayout(clazz)) : type;
            return LayoutEncoding.getPureInstanceSize(clazz.getHub(), true).rawValue();
        }
        if (type.isArray()) {
            return this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), Array.getLength(object), true);
        }
        throw VMError.shouldNotReachHereUnexpectedInput(type);
    }

    private boolean addArrayElements(Object[] array, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (Object element : array) {
            Object value = this.aUniverse.replaceObject(element);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || value instanceof RelocatedPointer;
            }
            this.recursiveAddObject(value, false, reason);
        }
        return relocatable;
    }

    private boolean addConstantArrayElements(JavaConstant array, int length, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (int idx = 0; idx < length; ++idx) {
            JavaConstant value = this.hConstantReflection.readArrayElement(array, idx);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || value instanceof RelocatableConstant;
            }
            this.recursiveAddConstant(value, false, reason);
        }
        return relocatable;
    }

    private void recursiveAddObject(Object original, boolean immutableFromParent, Object reason) {
        if (original != null) {
            this.addObjectWorklist.push(new AddObjectData(this.hUniverse.getSnippetReflection().forObject(original), immutableFromParent, reason));
        }
    }

    private void recursiveAddConstant(JavaConstant constant, boolean immutableFromParent, Object reason) {
        if (constant.isNonNull()) {
            this.addObjectWorklist.push(new AddObjectData(constant, immutableFromParent, reason));
        }
    }

    private void processAddObjectWorklist() {
        while (!this.addObjectWorklist.isEmpty()) {
            AddObjectData data = this.addObjectWorklist.pop();
            this.addConstant(data.original, data.immutableFromParent, data.reason);
        }
    }

    protected static final class Phase {
        private PhaseValue value = PhaseValue.BEFORE;

        public static Phase factory() {
            return new Phase();
        }

        public boolean isBefore() {
            return this.value == PhaseValue.BEFORE;
        }

        public void allow() {
            assert (this.value == PhaseValue.BEFORE) : "Can not allow while in phase " + this.value.toString();
            this.value = PhaseValue.ALLOWED;
        }

        void disallow() {
            assert (this.value == PhaseValue.ALLOWED) : "Can not disallow while in phase " + this.value.toString();
            this.value = PhaseValue.AFTER;
        }

        public boolean isAllowed() {
            return this.value == PhaseValue.ALLOWED;
        }

        public String toString() {
            return this.value.toString();
        }

        protected Phase() {
        }

        private static enum PhaseValue {
            BEFORE,
            ALLOWED,
            AFTER;

        }
    }

    public final class ObjectInfo
    implements ImageHeapObject {
        private final ImageHeapConstant constant;
        private final HostedClass clazz;
        private final long size;
        private final int identityHashCode;
        private ImageHeapPartition partition;
        private long offsetInPartition;
        private final Object reason;

        ObjectInfo(ImageHeapConstant constant, long size, HostedClass clazz, int identityHashCode, Object reason) {
            this.constant = constant;
            this.clazz = clazz;
            this.partition = null;
            this.offsetInPartition = -1L;
            this.size = size;
            this.identityHashCode = identityHashCode;
            this.reason = reason;
            if (NativeImageHeap.this.objectReachabilityInfo != null) {
                NativeImageHeap.this.objectReachabilityInfo.put(this, new ObjectReachabilityInfo(this, reason));
            }
        }

        @Override
        public Object getObject() {
            return NativeImageHeap.this.hUniverse.getSnippetReflection().asObject(Object.class, (JavaConstant)this.constant);
        }

        @Override
        public Class<?> getObjectClass() {
            return this.clazz.getJavaClass();
        }

        public ImageHeapConstant getConstant() {
            return this.constant;
        }

        public HostedClass getClazz() {
            return this.clazz;
        }

        @Override
        public long getOffset() {
            assert (this.offsetInPartition >= 0L);
            assert (this.partition != null);
            return this.partition.getStartOffset() + this.offsetInPartition;
        }

        @Override
        public void setOffsetInPartition(long value) {
            assert (this.offsetInPartition == -1L && value >= 0L);
            this.offsetInPartition = value;
        }

        @Override
        public ImageHeapPartition getPartition() {
            return this.partition;
        }

        @Override
        public void setHeapPartition(ImageHeapPartition value) {
            assert (this.partition == null);
            this.partition = value;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        int getIdentityHashCode() {
            return this.identityHashCode;
        }

        Object getMainReason() {
            return this.reason;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.constant.getType().toJavaName(true)).append(":").append(this.identityHashCode).append(" -> ");
            Object cur = this.getMainReason();
            Object prev = null;
            boolean skipped = false;
            while (cur instanceof ObjectInfo) {
                skipped = prev != null;
                prev = cur;
                cur = ((ObjectInfo)cur).getMainReason();
            }
            if (skipped) {
                result.append("... -> ");
            }
            if (prev != null) {
                result.append(prev);
            } else {
                result.append(cur);
            }
            return result.toString();
        }
    }

    static enum HeapInclusionReason {
        InternedStringsTable,
        FillerObject,
        StaticObjectFields,
        DataSection,
        StaticPrimitiveFields,
        Resource;

    }

    final class ObjectReachabilityInfo {
        private final LinkedHashSet<Object> allReasons = new LinkedHashSet();
        private int objectReachabilityGroup;

        ObjectReachabilityInfo(ObjectInfo info, Object firstReason) {
            this.allReasons.add(firstReason);
            this.objectReachabilityGroup = ObjectReachabilityGroup.getFlagForObjectInfo(info, firstReason, NativeImageHeap.this.objectReachabilityInfo);
        }

        void addReason(Object additionalReason) {
            this.allReasons.add(additionalReason);
            this.objectReachabilityGroup |= ObjectReachabilityGroup.getByReason(additionalReason, NativeImageHeap.this.objectReachabilityInfo);
        }

        Set<Object> getAllReasons() {
            return this.allReasons;
        }

        int getObjectReachabilityGroup() {
            return this.objectReachabilityGroup;
        }

        boolean objectReachableFrom(ObjectReachabilityGroup other) {
            return (this.objectReachabilityGroup & other.flag) != 0;
        }
    }

    static class AddObjectData {
        final JavaConstant original;
        final boolean immutableFromParent;
        final Object reason;

        AddObjectData(JavaConstant original, boolean immutableFromParent, Object reason) {
            this.original = original;
            this.immutableFromParent = immutableFromParent;
            this.reason = reason;
        }
    }

    static enum ObjectReachabilityGroup {
        Resources(2, "Resources byte arrays", "resources"),
        InternedStringsTable(4, "Interned strings table", "internedStringsTable"),
        DynamicHubs(8, "Class data", "classData"),
        ImageCodeInfo(16, "Code metadata", "codeMetadata"),
        MethodOrStaticField(32, "Connected components accessed from method or a static field", "connectedComponents"),
        Other(64, "Other", "other");

        public final int flag;
        public final String description;
        public final String name;

        private ObjectReachabilityGroup(int flag, String description, String name) {
            this.flag = flag;
            this.description = description;
            this.name = name;
        }

        static int getFlagForObjectInfo(ObjectInfo object, Object firstReason, Map<ObjectInfo, ObjectReachabilityInfo> additionalReasonInfoHashMap) {
            int result = 0;
            if (object.getObjectClass().equals(ImageCodeInfo.class)) {
                result |= ObjectReachabilityGroup.ImageCodeInfo.flag;
            }
            if (object.getObject() != null && (object.getObject().getClass().equals(DynamicHub.class) || object.getObject().getClass().equals(DynamicHubCompanion.class))) {
                result |= ObjectReachabilityGroup.DynamicHubs.flag;
            }
            return result |= ObjectReachabilityGroup.getByReason(firstReason, additionalReasonInfoHashMap);
        }

        static int getByReason(Object reason, Map<ObjectInfo, ObjectReachabilityInfo> additionalReasonInfoHashMap) {
            if (reason.equals((Object)HeapInclusionReason.InternedStringsTable)) {
                return ObjectReachabilityGroup.InternedStringsTable.flag;
            }
            if (reason.equals((Object)HeapInclusionReason.Resource)) {
                return ObjectReachabilityGroup.Resources.flag;
            }
            if (reason instanceof String || reason instanceof HostedField) {
                return ObjectReachabilityGroup.MethodOrStaticField.flag;
            }
            if (reason instanceof ObjectInfo) {
                ObjectInfo r = (ObjectInfo)reason;
                return additionalReasonInfoHashMap.get(r).getObjectReachabilityGroup();
            }
            return ObjectReachabilityGroup.Other.flag;
        }
    }
}

