/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageHeapScanner
extends ImageHeapScanner {
    private final ImageClassLoader loader;
    private final Class<?> economicMapImpl;
    private final Field economicMapImplEntriesField;
    private final Field economicMapImplHashArrayField;
    private final Field economicMapImplTotalEntriesField;
    private final Field economicMapImplDeletedEntriesField;
    private final ReflectionHostedSupport reflectionSupport;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport;

    public SVMImageHeapScanner(BigBang bb, ImageHeap imageHeap, ImageClassLoader loader, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver, HostedValuesProvider hostedValuesProvider) {
        super(bb, imageHeap, metaAccess, snippetReflection, aConstantReflection, aScanningObserver, hostedValuesProvider);
        this.loader = loader;
        this.economicMapImpl = this.getClass("org.graalvm.collections.EconomicMapImpl");
        this.economicMapImplEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"entries");
        this.economicMapImplHashArrayField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"hashArray");
        this.economicMapImplTotalEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"totalEntries");
        this.economicMapImplDeletedEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"deletedEntries");
        ImageSingletons.add(ImageHeapScanner.class, (Object)((Object)this));
        this.reflectionSupport = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        this.fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    }

    public static ImageHeapScanner instance() {
        return (ImageHeapScanner)ImageSingletons.lookup(ImageHeapScanner.class);
    }

    protected Class<?> getClass(String className) {
        return this.loader.findClassOrFail(className);
    }

    protected ImageHeapConstant getOrCreateImageHeapConstant(JavaConstant javaConstant, ObjectScanner.ScanReason reason) {
        return super.getOrCreateImageHeapConstant(javaConstant, reason);
    }

    public boolean isValueAvailable(AnalysisField field) {
        return this.fieldValueInterceptionSupport.isValueAvailable(field);
    }

    public JavaConstant readStaticFieldValue(AnalysisField field) {
        AnalysisConstantReflectionProvider aConstantReflection = (AnalysisConstantReflectionProvider)this.constantReflection;
        return aConstantReflection.readValue(field, null, true);
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> map) {
        super.rescanEconomicMap(map);
        if (map.getClass() == this.economicMapImpl) {
            this.rescanField(map, this.economicMapImplEntriesField);
            this.rescanField(map, this.economicMapImplHashArrayField);
            this.rescanField(map, this.economicMapImplTotalEntriesField);
            this.rescanField(map, this.economicMapImplDeletedEntriesField);
        }
    }

    protected void onObjectReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        super.onObjectReachable(imageHeapConstant, reason, onAnalysisModified);
        Object object = this.snippetReflection.asObject(Object.class, (JavaConstant)imageHeapConstant);
        if (object instanceof Field) {
            Field field = (Field)object;
            this.reflectionSupport.registerHeapReflectionField(field, reason);
        } else if (object instanceof Executable) {
            Executable executable = (Executable)object;
            this.reflectionSupport.registerHeapReflectionExecutable(executable, reason);
        } else if (object instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)object;
            this.reflectionSupport.registerHeapDynamicHub(hub, reason);
        }
    }
}

