/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.util.json.JsonBuilder;
import org.graalvm.nativeimage.hosted.Feature;

class CodeBreakdown {
    private boolean built = false;
    private Feature.AfterCompilationAccess access;
    private final Map<String, Integer> data = new HashMap<String, Integer>();

    CodeBreakdown(Feature.AfterCompilationAccess access) {
        this.access = access;
    }

    private void build() {
        if (this.built) {
            return;
        }
        for (CompileQueue.CompileTask task : ((FeatureImpl.AfterCompilationAccessImpl)this.access).getCompilationTasks()) {
            this.data.merge(task.method.format("%H.%n(%p) %r"), task.result.getTargetCodeSize(), Integer::sum);
        }
        this.access = null;
        this.built = true;
    }

    public Map<String, Integer> getData() {
        this.build();
        return this.data;
    }

    public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
        this.build();
        try (JsonBuilder.ArrayBuilder array = builder.append("code-size").array();){
            for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
                JsonBuilder.ObjectBuilder object = array.nextEntry().object();
                try {
                    object.append("name", (Object)entry.getKey()).append("size", (Object)entry.getValue());
                }
                finally {
                    if (object == null) continue;
                    object.close();
                }
            }
        }
    }
}

