/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Set;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;

public class DynamicHubLayout {
    private final ObjectLayout layout;
    private final HostedInstanceClass dynamicHubType;
    public final HostedField closedTypeWorldTypeCheckSlotsField;
    private final int closedTypeWorldTypeCheckSlotsOffset;
    private final int closedTypeWorldTypeCheckSlotSize;
    public final HostedField vTableField;
    public final int vTableSlotSize;
    public final JavaKind vTableSlotStorageKind;
    private final Set<HostedField> ignoredFields;
    private int vTableOffset;

    public DynamicHubLayout(ObjectLayout layout, HostedType dynamicHubType, HostedField closedTypeWorldTypeCheckSlotsField, int closedTypeWorldTypeCheckSlotsOffset, int closedTypeWorldTypeCheckSlotSize, HostedField vTableField, JavaKind vTableSlotStorageKind, int vTableSlotSize, Set<HostedField> ignoredFields) {
        this.layout = layout;
        this.dynamicHubType = (HostedInstanceClass)dynamicHubType;
        this.closedTypeWorldTypeCheckSlotsField = closedTypeWorldTypeCheckSlotsField;
        this.closedTypeWorldTypeCheckSlotsOffset = closedTypeWorldTypeCheckSlotsOffset;
        this.closedTypeWorldTypeCheckSlotSize = closedTypeWorldTypeCheckSlotSize;
        this.vTableField = vTableField;
        this.vTableSlotStorageKind = vTableSlotStorageKind;
        this.vTableSlotSize = vTableSlotSize;
        this.ignoredFields = ignoredFields;
    }

    public static DynamicHubLayout singleton() {
        return (DynamicHubLayout)ImageSingletons.lookup(DynamicHubLayout.class);
    }

    public JavaKind getVTableSlotStorageKind() {
        return this.vTableSlotStorageKind;
    }

    public boolean isIgnoredField(HostedField field) {
        return this.ignoredFields.contains(field);
    }

    public Set<HostedField> getIgnoredFields() {
        return this.ignoredFields;
    }

    public boolean isDynamicHub(HostedType type) {
        return type.equals(this.dynamicHubType);
    }

    public boolean isInlinedField(HostedField field) {
        return field.equals(this.closedTypeWorldTypeCheckSlotsField) || field.equals(this.vTableField);
    }

    public int getVTableSlotOffset(int index) {
        return this.vTableOffset() + index * this.vTableSlotSize;
    }

    public int getClosedTypeWorldTypeCheckSlotsOffset() {
        assert (SubstrateOptions.closedTypeWorld());
        return this.closedTypeWorldTypeCheckSlotsOffset;
    }

    public int getClosedTypeWorldTypeCheckSlotsOffset(int index) {
        assert (SubstrateOptions.closedTypeWorld());
        return this.closedTypeWorldTypeCheckSlotsOffset + index * this.closedTypeWorldTypeCheckSlotSize;
    }

    public int getVTableLengthOffset() {
        return this.layout.getArrayLengthOffset();
    }

    public int vTableOffset() {
        if (this.vTableOffset == 0) {
            this.vTableOffset = NumUtil.roundUp((int)this.dynamicHubType.getAfterFieldsOffset(), (int)this.vTableSlotSize);
        }
        return this.vTableOffset;
    }

    public long getTotalSize(int vtableLength) {
        return this.layout.computeArrayTotalSize(this.getVTableSlotOffset(vtableLength), true);
    }

    public long getIdentityHashOffset(int vTableLength) {
        return this.layout.getArrayIdentityHashOffset(this.getVTableSlotOffset(vTableLength));
    }
}

