/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

final class IsolateAwareSnippetReflectionProvider
implements SnippetReflectionProvider {
    IsolateAwareSnippetReflectionProvider() {
    }

    public JavaConstant forObject(Object object) {
        VMError.guarantee(!SubstrateOptions.shouldCompileInIsolates() || ImageHeapObjects.isInImageHeap(object));
        return SubstrateObjectConstant.forObject(object);
    }

    public <T> T asObject(Class<T> type, JavaConstant constant) {
        T object = SubstrateObjectConstant.asObject(type, constant);
        VMError.guarantee(!SubstrateOptions.shouldCompileInIsolates() || ImageHeapObjects.isInImageHeap(object));
        return object;
    }

    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Class<?> originalClass(ResolvedJavaType type) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Executable originalMethod(ResolvedJavaMethod method) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Field originalField(ResolvedJavaField field) {
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

