/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class PthreadVMLockSupport
extends VMLockSupport {
    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VMMutex replaceVMMutex(VMMutex source) {
        return new PthreadVMMutex(source.getName());
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VMCondition replaceVMCondition(VMCondition source) {
        return new PthreadVMCondition((PthreadVMMutex)this.mutexReplacer.apply(source.getMutex()), source.getConditionName());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void checkResult(int result, String functionName) {
        if (result != 0) {
            PthreadVMLockSupport.fatalError(result, functionName);
        }
    }

    @Uninterruptible(reason="Error handling is interruptible.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void fatalError(int result, String functionName) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        Log.log().string(functionName).string(" returned ").signed(result).newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }
}

