/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.throttling;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibM;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.throttling.JfrSamplerParams;
import com.oracle.svm.core.jfr.throttling.JfrSamplerWindow;
import com.oracle.svm.core.jfr.utils.JfrRandom;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.util.BasedOnJDKFile;
import jdk.internal.misc.Unsafe;

abstract class JfrAdaptiveSampler {
    private static final Unsafe U = Unsafe.getUnsafe();
    protected static final long LOCK_OFFSET = U.objectFieldOffset(JfrAdaptiveSampler.class, "lock");
    private static final long ACTIVE_WINDOW_OFFSET = U.objectFieldOffset(JfrAdaptiveSampler.class, "activeWindow");
    private final JfrRandom prng = new JfrRandom();
    private final JfrSamplerWindow window0 = new JfrSamplerWindow();
    private final JfrSamplerWindow window1 = new JfrSamplerWindow();
    private volatile int lock;
    protected JfrSamplerWindow activeWindow = this.window0;
    protected double avgPopulationSize;
    private double ewmaPopulationSizeAlpha;
    private long accumulatedDebtCarryLimit;
    private long accumulatedDebtCarryCount;

    JfrAdaptiveSampler() {
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L79-L89")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean sample(long timestampNs) {
        boolean expired = this.activeWindow.isExpired(timestampNs);
        if (expired) {
            if (JavaSpinLockUtils.tryLock(this, LOCK_OFFSET)) {
                if (this.activeWindow.isExpired(timestampNs)) {
                    this.rotate(this.activeWindow);
                }
                JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
            }
            return false;
        }
        return this.activeWindow.sample();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void reconfigure() {
        this.rotate(this.activeWindow);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void rotate(JfrSamplerWindow expired) {
        JfrSamplerWindow next = this.getNextWindow(expired);
        JfrSamplerParams params = this.nextWindowParams();
        this.configure(params, expired, next);
        U.putReferenceRelease(this, ACTIVE_WINDOW_OFFSET, next);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract JfrSamplerParams nextWindowParams();

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L145-L156")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void configure(JfrSamplerParams params, JfrSamplerWindow expired, JfrSamplerWindow next) {
        if (params.reconfigure) {
            expired.copyParams(params);
            next.copyParams(params);
            this.avgPopulationSize = 0.0;
            this.ewmaPopulationSizeAlpha = JfrAdaptiveSampler.computeEwmaAlphaCoefficient(params.windowLookbackCount);
            this.accumulatedDebtCarryCount = this.accumulatedDebtCarryLimit = JfrAdaptiveSampler.computeAccumulatedDebtCarryLimit(params.windowDurationMs);
            params.reconfigure = false;
        }
        this.setRate(params, expired, next);
        next.initialize(params.windowDurationMs);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L173-L175")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static double computeEwmaAlphaCoefficient(long lookbackCount) {
        return lookbackCount <= 1L ? 1.0 : 1.0 / (double)lookbackCount;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L177-L182")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long computeAccumulatedDebtCarryLimit(long windowDurationMs) {
        if (windowDurationMs == 0L || windowDurationMs >= 1000L) {
            return 1L;
        }
        return 1000L / windowDurationMs;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L217-L229")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setRate(JfrSamplerParams params, JfrSamplerWindow expired, JfrSamplerWindow next) {
        long sampleSize = this.projectSampleSize(params, expired);
        if (sampleSize == 0L) {
            next.setProjectedPopulationSize(0L);
            return;
        }
        next.setSamplingInterval(this.deriveSamplingInterval(sampleSize, expired));
        assert (next.getSamplingInterval() >= 1L);
        next.setProjectedPopulationSize(sampleSize * next.getSamplingInterval());
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L236-L238")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long projectSampleSize(JfrSamplerParams params, JfrSamplerWindow expired) {
        return params.samplePointsPerWindow + this.amortizeDebt(expired);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L259-L269")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected long amortizeDebt(JfrSamplerWindow expired) {
        long accumulatedDebt = expired.getAccumulatedDebt();
        assert (accumulatedDebt <= 0L);
        if (this.accumulatedDebtCarryCount == this.accumulatedDebtCarryLimit) {
            this.accumulatedDebtCarryCount = 1L;
            return 0L;
        }
        ++this.accumulatedDebtCarryCount;
        return -accumulatedDebt;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L316-L325")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long deriveSamplingInterval(double sampleSize, JfrSamplerWindow expired) {
        assert (sampleSize > 0.0);
        double populationSize = this.projectPopulationSize(expired);
        if (populationSize <= sampleSize) {
            return 1L;
        }
        assert (populationSize > 0.0);
        double projectedProbability = sampleSize / populationSize;
        return this.nextGeometric(projectedProbability);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private double projectPopulationSize(JfrSamplerWindow expired) {
        this.avgPopulationSize = JfrAdaptiveSampler.exponentiallyWeightedMovingAverage(expired.getPopulationSize(), this.ewmaPopulationSizeAlpha, this.avgPopulationSize);
        return this.avgPopulationSize;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L169-L171")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static double exponentiallyWeightedMovingAverage(double currentMeasurement, double alpha, double prevEwma) {
        return alpha * currentMeasurement + (1.0 - alpha) * prevEwma;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/support/jfrAdaptiveSampler.cpp#L304-L314")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long nextGeometric(double p) {
        double u = this.prng.nextUniform();
        assert (u >= 0.0);
        assert (u <= 1.0);
        if (u == 0.0) {
            u = 0.01;
        } else if (u == 1.0) {
            u = 0.99;
        }
        return UninterruptibleUtils.Math.ceilToLong(LibM.log(1.0 - u) / LibM.log(1.0 - p));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private JfrSamplerWindow getNextWindow(JfrSamplerWindow expired) {
        return expired == this.window0 ? this.window1 : this.window0;
    }
}

