/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jdk.JDK22OrLater;
import com.oracle.svm.core.jdk.JDK23OrLater;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.HasFileDeltaChangeField;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.util.PlatformTimeUtils;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class, onlyWith={HasJfrSupport.class})
public final class Target_jdk_jfr_internal_JVM {
    @Alias
    @TargetElement(onlyWith={HasChunkRotationMonitorField.class})
    static Object CHUNK_ROTATION_MONITOR;
    @Alias
    @TargetElement(onlyWith={HasFileDeltaChangeField.class})
    static Object FILE_DELTA_CHANGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @TargetElement(onlyWith={JDK22OrLater.class})
    private static volatile boolean nativeOK;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void markChunkFinal() {
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void beginRecording() {
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isRecording() {
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void endRecording() {
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public static long counterTime() {
        return JfrTicks.elapsedTicks();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getClassId().")
    public static long getClassId(Class<?> clazz) {
        return SubstrateJVM.get().getClassId(clazz);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getStackTraceId(int skipCount, long stackFilterId) {
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long registerStackFilter(String[] classes, String[] methods) {
        throw VMError.unimplemented("JFR StackFilters are not yet supported.");
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void unregisterStackFilter(long stackFilterId) {
        throw VMError.unimplemented("JFR StackFilters are not yet supported.");
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setMiscellaneous(long eventTypeId, long value) {
        Logger.log(LogTag.JFR_SETTING, LogLevel.WARN, "@Deprecated JFR events, and leak profiling are not yet supported.");
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getThreadId(Thread t) {
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    @TargetElement(onlyWith={JDK23OrLater.class})
    public static long nanosNow() {
        return PlatformTimeUtils.singleton().nanosNow();
    }

    @Substitute
    public static void log(int tagSetId, int level, String message) {
        SubstrateJVM.get().log(tagSetId, level, message);
    }

    @Substitute
    public static void logEvent(int level, String[] lines, boolean system) {
        SubstrateJVM.get().logEvent(level, lines, system);
    }

    @Substitute
    public static void subscribeLogLevel(LogTag lt, int tagSetId) {
        SubstrateJVM.get().subscribeLogLevel(lt, tagSetId);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setFileNotification(long delta) {
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setGlobalBufferSize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setMemorySize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setMethodSamplingPeriod(long type, long intervalMillis) {
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setOutput(String file) {
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setForceInstrumentation(boolean force) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean setThreshold(long eventTypeId, long ticks) {
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void storeMetadataDescriptor(byte[] bytes) {
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    private static boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    private static boolean destroyJFR() {
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isAvailable() {
        return true;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getTypeId(Class<?> clazz) {
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter getEventWriter() {
        return SubstrateJVM.get().getEventWriter();
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter newEventWriter() {
        return SubstrateJVM.get().newEventWriter();
    }

    @Substitute
    public static void flush(Target_jdk_jfr_internal_event_EventWriter writer, int uncommittedSize, int requestedSize) {
        SubstrateJVM.get().flush(writer, uncommittedSize, requestedSize);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void flush() {
        SubstrateJVM.get().flush();
    }

    @Substitute
    public static long commit(long nextPosition) {
        return SubstrateJVM.get().commit(nextPosition);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setRepositoryLocation(String dirText) {
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void setDumpPath(String dumpPathText) {
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static String getDumpPath() {
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void abort(String errorMsg) {
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public static boolean addStringConstant(long id, String s) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean setCutoff(long eventTypeId, long cutoffTicks) {
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        return SubstrateJVM.get().setThrottle(eventTypeId, eventSampleSize, periodMs);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
        SubstrateJVM.get().emitOldObjectSamples(cutoff, emitAll, skipBFS);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean shouldRotateDisk() {
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void include(Thread thread) {
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static void exclude(Thread thread) {
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isExcluded(Thread thread) {
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isExcluded(Class<? extends Event> eventClass) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isInstrumented(Class<? extends Event> eventClass) {
        return true;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getChunkStartNanos() {
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static Object getConfiguration(Class<? extends Event> eventClass) {
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static boolean isContainerized() {
        return Containers.isContainerized();
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    public static long hostTotalMemory() {
        return ((PhysicalMemory.PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemory.PhysicalMemorySupport.class)).size().rawValue();
    }

    @Substitute
    @TargetElement(onlyWith={JDK23OrLater.class})
    public static long hostTotalSwapMemory() {
        return -1L;
    }
}

