/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.misc.Unsafe;

@TargetClass(className="java.util.concurrent.atomic.AtomicReferenceFieldUpdater$AtomicReferenceFieldUpdaterImpl")
final class Target_java_util_concurrent_atomic_AtomicReferenceFieldUpdater_AtomicReferenceFieldUpdaterImpl {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset)
    private long offset;
    @Alias
    private Class<?> cclass;
    @Alias
    private Class<?> tclass;
    @Alias
    private Class<?> vclass;

    @Substitute
    Target_java_util_concurrent_atomic_AtomicReferenceFieldUpdater_AtomicReferenceFieldUpdaterImpl(Class<?> tclass, Class<?> vclass, String fieldName, Class<?> caller) {
        Class<?> fieldClass;
        int modifiers;
        Field field;
        try {
            field = tclass.getDeclaredField(fieldName);
            modifiers = field.getModifiers();
            fieldClass = field.getType();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (vclass != fieldClass) {
            throw new ClassCastException();
        }
        if (vclass.isPrimitive()) {
            throw new IllegalArgumentException("Must be reference type");
        }
        if (!Modifier.isVolatile(modifiers)) {
            throw new IllegalArgumentException("Must be volatile type");
        }
        this.cclass = tclass;
        this.tclass = tclass;
        this.vclass = vclass;
        this.offset = Unsafe.getUnsafe().objectFieldOffset(field);
    }
}

