/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.VMError;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

@TargetClass(value=System.class)
final class Target_java_lang_System {
    @Alias
    private static PrintStream out;
    @Alias
    private static PrintStream err;
    @Alias
    private static InputStream in;
    @Delete
    private static Properties props;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias, isFinal=true)
    private static int allowSecurityManager;

    Target_java_lang_System() {
    }

    @Substitute
    private static void setIn(InputStream is) {
        in = is;
    }

    @Substitute
    private static void setOut(PrintStream ps) {
        out = ps;
    }

    @Substitute
    private static void setErr(PrintStream ps) {
        err = ps;
    }

    @Substitute
    private static int identityHashCode(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in SubstrateGraphBuilderPlugins");
    }

    @Substitute
    private static Properties getProperties() {
        return SystemPropertiesSupport.singleton().getProperties();
    }

    @Substitute
    private static void setProperties(Properties props) {
        SystemPropertiesSupport.singleton().setProperties(props);
    }

    @Substitute
    public static String setProperty(String key, String value) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().setProperty(key, value);
    }

    @Substitute
    private static String getProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().getProperty(key);
    }

    @Substitute
    public static String clearProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().clearProperty(key);
    }

    @Substitute
    private static String getProperty(String key, String def) {
        String result = Target_java_lang_System.getProperty(key);
        return result != null ? result : def;
    }

    @Alias
    private static native void checkKey(String var0);

    @Substitute
    private static void setSecurityManager(SecurityManager sm) {
        if (sm != null) {
            String smp = SystemPropertiesSupport.singleton().getSavedProperties().get("java.security.manager");
            if (smp != null && !smp.equals("disallow")) {
                throw new SecurityException("Setting the SecurityManager is not supported by Native Image");
            }
            throw new UnsupportedOperationException("The Security Manager is deprecated and will be removed in a future release");
        }
    }

    static {
        allowSecurityManager = 1;
    }
}

