/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BooleanSupplier;

class JavaLoggingModule {
    private static final Object logManager;
    private static final Method logManagerGetProperty;

    JavaLoggingModule() {
    }

    static String logManagerGetProperty(String name) {
        try {
            return (String)logManagerGetProperty.invoke(logManager, name);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Unable to reflectively invoke java.util.logging.LogManager.getProperty(String)", e);
        }
    }

    private static boolean isPresent() {
        return logManager != null;
    }

    static {
        Optional<Module> javaLoggingModule = ModuleLayer.boot().findModule("java.logging");
        if (javaLoggingModule.isPresent() && JavaLoggingModule.class.getModule().canRead(javaLoggingModule.get())) {
            Class logManagerClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.util.logging.LogManager");
            Method logManagerGetLogManagerMethod = ReflectionUtil.lookupMethod((Class)logManagerClass, (String)"getLogManager", (Class[])new Class[0]);
            logManagerGetProperty = ReflectionUtil.lookupMethod((Class)logManagerClass, (String)"getProperty", (Class[])new Class[]{String.class});
            try {
                logManager = logManagerGetLogManagerMethod.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Unable to reflectively invoke java.util.logging.LogManager.getLogManager()", e);
            }
        } else {
            logManager = null;
            logManagerGetProperty = null;
        }
    }

    static class IsPresent
    implements BooleanSupplier {
        IsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return JavaLoggingModule.isPresent();
        }
    }
}

