/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import java.lang.ref.Reference;
import java.util.List;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public abstract class Heap {
    protected long startOffset;

    @Fold
    public static Heap getHeap() {
        return (Heap)ImageSingletons.lookup(Heap.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected Heap() {
    }

    @Uninterruptible(reason="Called during startup.")
    public abstract void attachThread(IsolateThread var1);

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    public abstract void detachThread(IsolateThread var1);

    public abstract void suspendAllocation();

    public abstract void resumeAllocation();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isAllocationDisallowed();

    public abstract GC getGC();

    public abstract RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport();

    public abstract boolean walkObjects(ObjectVisitor var1);

    public abstract boolean walkImageHeapObjects(ObjectVisitor var1);

    public abstract boolean walkCollectedHeapObjects(ObjectVisitor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract int getClassCount();

    public void visitLoadedClasses(Consumer<Class<?>> visitor) {
        for (Class<?> clazz : this.getAllClasses()) {
            if (!DynamicHub.fromClass(clazz).isLoaded()) continue;
            visitor.accept(clazz);
        }
    }

    protected abstract List<Class<?>> getAllClasses();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract ObjectHeader getObjectHeader();

    @Uninterruptible(reason="Tear-down in progress.")
    public abstract boolean tearDown();

    public abstract void prepareForSafepoint();

    public abstract void endSafepoint();

    @Fold
    public abstract int getPreferredAddressSpaceAlignment();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getImageHeapStart() {
        Pointer heapBase = (Pointer)Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return heapBase.add(Heap.getHeap().getImageHeapOffsetInAddressSpace());
    }

    @Fold
    public abstract int getImageHeapOffsetInAddressSpace();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInImageHeap(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInImageHeap(Pointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInPrimaryImageHeap(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInPrimaryImageHeap(Pointer var1);

    public abstract void doReferenceHandling();

    public abstract boolean hasReferencePendingList();

    public abstract void waitForReferencePendingList() throws InterruptedException;

    public abstract void wakeUpReferencePendingListWaiters();

    public abstract Reference<?> getAndClearReferencePendingList();

    public abstract boolean printLocationInfo(Log var1, UnsignedWord var2, boolean var3, boolean var4);

    public abstract void optionValueChanged(RuntimeOptionKey<?> var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract long getThreadAllocatedMemory(IsolateThread var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract UnsignedWord getUsedMemoryAfterLastGC();

    @Uninterruptible(reason="Ensure that no GC can occur between modification of the object and this call.", callerMustBe=true)
    public abstract void dirtyAllReferencesOf(Object var1);

    public abstract long getMillisSinceLastWholeHeapExamined();

    @Uninterruptible(reason="Ensure that no GC can occur between this call and usage of the salt.", callerMustBe=true)
    public abstract long getIdentityHashSalt(Object var1);

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }
}

