/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.util.ImageHeapList;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
class GCCauseSupport {
    final List<GCCause> gcCauses = ImageHeapList.create(GCCause.class, null);

    GCCauseSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    Object collectGCCauses(Object obj) {
        if (obj instanceof GCCause) {
            GCCause gcCause = (GCCause)obj;
            List<GCCause> list = this.gcCauses;
            synchronized (list) {
                int id = gcCause.getId();
                while (this.gcCauses.size() <= id) {
                    this.gcCauses.add(null);
                }
                GCCause existing = this.gcCauses.set(id, gcCause);
                if (existing != null && existing != gcCause) {
                    throw VMError.shouldNotReachHere("Two GCCause objects have the same id " + id + ": " + gcCause.getName() + ", " + existing.getName());
                }
            }
        }
        return obj;
    }
}

