/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class UnalignedHeapChunk {
    private UnalignedHeapChunk() {
    }

    public static void initialize(UnalignedHeader chunk, UnsignedWord chunkSize) {
        HeapChunk.initialize(chunk, UnalignedHeapChunk.getObjectStart(chunk), chunkSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectStart(UnalignedHeader that) {
        return HeapChunk.asPointer(that).add(UnalignedHeapChunk.getObjectStartOffset());
    }

    public static Pointer getObjectEnd(UnalignedHeader that) {
        return HeapChunk.getEndPointer(that);
    }

    static UnsignedWord getChunkSizeForObject(UnsignedWord objectSize) {
        UnsignedWord objectStart = UnalignedHeapChunk.getObjectStartOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(objectStart.add(objectSize), alignment);
    }

    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public static Pointer allocateMemory(UnalignedHeader that, UnsignedWord size) {
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        Pointer result = (Pointer)WordFactory.nullPointer();
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnalignedHeader getEnclosingChunk(Object obj) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        return UnalignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)objPointer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnalignedHeader getEnclosingChunkFromObjectPointer(Pointer ptr) {
        if (!GraalDirectives.inIntrinsic()) assert (HeapImpl.isImageHeapAligned() || !HeapImpl.getHeapImpl().isInImageHeap(ptr)) : "can't be used for the image heap because the image heap is not aligned to the chunk size";
        Pointer chunkPointer = ptr.subtract(UnalignedHeapChunk.getObjectStartOffset());
        return (UnalignedHeader)chunkPointer;
    }

    public static boolean walkObjects(UnalignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFrom(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkObjectsInline(UnalignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    @Fold
    static UnsignedWord getObjectStartOffset() {
        return RememberedSet.get().getHeaderSizeOfUnalignedChunk();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCommittedObjectMemory(UnalignedHeader that) {
        return HeapChunk.getEndOffset(that).subtract(UnalignedHeapChunk.getObjectStartOffset());
    }

    @RawStructure
    public static interface UnalignedHeader
    extends HeapChunk.Header<UnalignedHeader> {
    }
}

