/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.fieldvaluetransformer.BoxingTransformer;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.graal.nodes.FieldOffsetNode;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public final class FieldOffsetFieldValueTransformer
extends BoxingTransformer
implements FieldValueTransformerWithAvailability {
    private final Field targetField;

    public FieldOffsetFieldValueTransformer(Field targetField, JavaKind returnKind) {
        super(returnKind);
        this.targetField = targetField;
    }

    @Override
    public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
        return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
    }

    public Object transform(Object receiver, Object originalValue) {
        int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(this.targetField, true);
        if (offset <= 0) {
            throw VMError.shouldNotReachHere("Field is not marked as unsafe accessed: " + String.valueOf(this.targetField));
        }
        return this.box(offset);
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        return FieldOffsetNode.create(this.returnKind, providers.getMetaAccess().lookupJavaField(this.targetField));
    }
}

