/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import java.lang.reflect.Member;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

@AutomaticallyRegisteredImageSingleton(value={UniqueShortNameProvider.class}, onlyWith={UseDefault.class})
public class UniqueShortNameProviderDefaultImpl
implements UniqueShortNameProvider {
    @Override
    public String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        return SubstrateUtil.defaultUniqueShortName(SubstrateUtil.classLoaderNameAndId(loader), declaringClass, methodName, methodSignature, isConstructor);
    }

    @Override
    public String uniqueShortName(Member m) {
        return SubstrateUtil.defaultUniqueShortName(m);
    }

    @Override
    public String uniqueShortLoaderName(ClassLoader classLoader) {
        return SubstrateUtil.classLoaderNameAndId(classLoader);
    }

    public static class UseDefault
    implements BooleanSupplier {
        public static boolean useDefaultProvider() {
            return !OS.LINUX.isCurrent() || !SubstrateOptions.useDebugInfoGeneration();
        }

        @Override
        public boolean getAsBoolean() {
            return UseDefault.useDefaultProvider();
        }
    }
}

